/*
 * Decompiled with CFR 0.152.
 */
package com.scarasol.zombiekit.block;

import com.scarasol.zombiekit.block.BombBlock;
import com.scarasol.zombiekit.entity.projectile.LandmineEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.registries.ForgeRegistries;

public class LandmineBlock
extends Block
implements BombBlock {
    public List<Tuple<Tuple<String, Integer>, Integer>> areaEffectCloudEffect = new ArrayList<Tuple<Tuple<String, Integer>, Integer>>();

    public LandmineBlock(BlockBehaviour.Properties properties, List<Tuple<Tuple<String, Integer>, Integer>> areaEffectCloudEffect) {
        super(properties);
        this.areaEffectCloudEffect.addAll(areaEffectCloudEffect);
    }

    public boolean m_7420_(BlockState state, BlockGetter reader, BlockPos pos) {
        return true;
    }

    public int m_7753_(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return 0;
    }

    public VoxelShape m_5909_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.m_83040_();
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        Vec3 offset = state.m_60824_(world, pos);
        return LandmineBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0).m_83216_(offset.f_82479_, offset.f_82480_, offset.f_82481_);
    }

    public boolean m_7898_(BlockState blockstate, LevelReader worldIn, BlockPos pos) {
        if (worldIn instanceof LevelAccessor) {
            LevelAccessor world = (LevelAccessor)worldIn;
            return world.m_8055_(pos.m_7495_()).m_60815_();
        }
        return super.m_7898_(blockstate, worldIn, pos);
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor world, BlockPos currentPos, BlockPos facingPos) {
        return !state.m_60710_((LevelReader)world, currentPos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(state, facing, facingState, world, currentPos, facingPos);
    }

    public BlockPathTypes getBlockPathType(BlockState state, BlockGetter world, BlockPos pos, Mob entity) {
        return BlockPathTypes.WALKABLE;
    }

    public PushReaction getPistonPushReaction(BlockState state) {
        return PushReaction.DESTROY;
    }

    @Override
    public int getExplodeLevel() {
        return this.areaEffectCloudEffect.isEmpty() ? 4 : 1;
    }

    public boolean canHarvestBlock(BlockState state, BlockGetter world, BlockPos pos, Player player) {
        Item item = player.m_150109_().m_36056_().m_41720_();
        if (item instanceof ShovelItem) {
            ShovelItem tieredItem = (ShovelItem)item;
            return tieredItem.m_43314_().m_6604_() >= 1;
        }
        return false;
    }

    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder builder) {
        List dropsOriginal = super.m_49635_(state, builder);
        if (!dropsOriginal.isEmpty()) {
            return dropsOriginal;
        }
        return Collections.singletonList(new ItemStack((ItemLike)this, 1));
    }

    public boolean onDestroyedByPlayer(BlockState blockstate, Level world, BlockPos pos, Player entity, boolean willHarvest, FluidState fluid) {
        boolean retval = super.onDestroyedByPlayer(blockstate, world, pos, entity, willHarvest, fluid);
        if (entity.m_21205_().m_41720_() instanceof ShovelItem || entity.m_7500_()) {
            return retval;
        }
        this.exploded(world, pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), this.getExplodeLevel());
        return retval;
    }

    public void m_7592_(Level world, BlockPos pos, Explosion e) {
        super.m_7592_(world, pos, e);
        this.exploded(world, pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), this.getExplodeLevel());
        if (!this.areaEffectCloudEffect.isEmpty()) {
            this.spawnAreaEffectCloud(world, pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
        }
    }

    public void m_6256_(BlockState blockstate, Level world, BlockPos pos, Player entity) {
        super.m_6256_(blockstate, world, pos, entity);
        if (entity.m_21205_().m_41720_() instanceof ShovelItem || entity.m_7500_()) {
            return;
        }
        this.exploded(world, pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), this.getExplodeLevel());
        if (!this.areaEffectCloudEffect.isEmpty()) {
            this.spawnAreaEffectCloud(world, pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
        }
    }

    public void m_7892_(BlockState blockstate, Level world, BlockPos pos, Entity entity) {
        super.m_7892_(blockstate, world, pos, entity);
        if (entity instanceof LandmineEntity) {
            return;
        }
        this.exploded(world, pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), this.getExplodeLevel());
        if (!this.areaEffectCloudEffect.isEmpty()) {
            this.spawnAreaEffectCloud(world, pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
        }
    }

    public InteractionResult m_6227_(BlockState blockstate, Level world, BlockPos pos, Player entity, InteractionHand hand, BlockHitResult hit) {
        super.m_6227_(blockstate, world, pos, entity, hand, hit);
        int x = pos.m_123341_();
        int y = pos.m_123342_();
        int z = pos.m_123343_();
        this.exploded(world, x, y, z, this.getExplodeLevel());
        if (!this.areaEffectCloudEffect.isEmpty()) {
            this.spawnAreaEffectCloud(world, x, y, z);
        }
        return InteractionResult.SUCCESS;
    }

    public void spawnAreaEffectCloud(Level level, int x, int y, int z) {
        AreaEffectCloud areaEffectCloud = new AreaEffectCloud(level, (double)x, (double)y, (double)z);
        areaEffectCloud.m_19734_(200);
        areaEffectCloud.m_19712_(4.0f);
        for (Tuple<Tuple<String, Integer>, Integer> effectInstance : this.areaEffectCloudEffect) {
            MobEffect effect = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(new ResourceLocation((String)((Tuple)effectInstance.m_14418_()).m_14418_()));
            if (effect == null) continue;
            areaEffectCloud.m_19716_(new MobEffectInstance(effect, ((Integer)((Tuple)effectInstance.m_14418_()).m_14419_()).intValue(), ((Integer)effectInstance.m_14419_()).intValue(), false, false));
        }
        level.m_7967_((Entity)areaEffectCloud);
    }
}

