/*
 * Decompiled with CFR 0.152.
 */
package com.scarasol.zombiekit.block;

import com.scarasol.sona.init.SonaMobEffects;
import com.scarasol.zombiekit.block.entity.InjectorBlockEntity;
import com.scarasol.zombiekit.init.ZombieKitItems;
import com.scarasol.zombiekit.init.ZombieKitSounds;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.items.ItemHandlerHelper;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class InjectorBlock
extends Block
implements EntityBlock {
    public static final IntegerProperty BOTTLE0 = IntegerProperty.m_61631_((String)"bottle0", (int)0, (int)5);
    public static final IntegerProperty BOTTLE1 = IntegerProperty.m_61631_((String)"bottle1", (int)0, (int)5);
    public static final IntegerProperty BOTTLE2 = IntegerProperty.m_61631_((String)"bottle2", (int)0, (int)5);
    public static final IntegerProperty BOTTLE3 = IntegerProperty.m_61631_((String)"bottle3", (int)0, (int)5);
    public static final IntegerProperty COOLDOWN = IntegerProperty.m_61631_((String)"cooldown", (int)0, (int)5);
    public static final BooleanProperty FULL = BooleanProperty.m_61465_((String)"full");
    private IntegerProperty[] bottles = new IntegerProperty[]{BOTTLE0, BOTTLE1, BOTTLE2, BOTTLE3};
    private static Map<Item, Integer> items;
    private DustParticleOptions nitricAcid = new DustParticleOptions(new Vector3f((Vector3fc)Vec3.m_82501_((int)15329627).m_252839_()), 1.0f);

    public InjectorBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FULL, (Comparable)Boolean.valueOf(false))).m_61124_((Property)COOLDOWN, (Comparable)Integer.valueOf(0))).m_61124_((Property)BOTTLE0, (Comparable)Integer.valueOf(0))).m_61124_((Property)BOTTLE1, (Comparable)Integer.valueOf(0))).m_61124_((Property)BOTTLE2, (Comparable)Integer.valueOf(0))).m_61124_((Property)BOTTLE3, (Comparable)Integer.valueOf(0)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{BOTTLE0});
        builder.m_61104_(new Property[]{BOTTLE1});
        builder.m_61104_(new Property[]{BOTTLE2});
        builder.m_61104_(new Property[]{BOTTLE3});
        builder.m_61104_(new Property[]{COOLDOWN});
        builder.m_61104_(new Property[]{FULL});
    }

    public InteractionResult m_6227_(BlockState blockstate, Level world, BlockPos pos, Player entity, InteractionHand hand, BlockHitResult hit) {
        super.m_6227_(blockstate, world, pos, entity, hand, hit);
        return this.rightClickInjector(world, pos, blockstate, entity, hand) ? InteractionResult.SUCCESS : InteractionResult.PASS;
    }

    public static void init() {
        if (items == null) {
            items = new HashMap<Item, Integer>();
            items.put((Item)ZombieKitItems.ALCOHOL.get(), 1);
            items.put(Items.f_151055_, 2);
            items.put((Item)ZombieKitItems.HYDROGEN_NITRATE.get(), 3);
            items.put(Items.f_151056_, 4);
            items.put(Items.f_42518_, 5);
        }
    }

    public boolean rightClickInjector(Level world, BlockPos pos, BlockState blockstate, Player player, InteractionHand hand) {
        boolean result = items.containsKey(player.m_21120_(hand).m_41720_());
        if (result) {
            this.load(world, pos, blockstate, player.m_21120_(hand), player, false);
        }
        return result;
    }

    public boolean load(Level world, BlockPos pos, BlockState blockstate, ItemStack itemStack, Player player, boolean auto) {
        for (int i = 0; i < 4; ++i) {
            if ((Integer)blockstate.m_61143_((Property)this.bottles[i]) != 0) continue;
            int cooldown = (Integer)blockstate.m_61143_((Property)COOLDOWN);
            if (auto && cooldown > 0) {
                if (i == 3) {
                    world.m_7731_(pos, (BlockState)((BlockState)((BlockState)blockstate.m_61124_((Property)COOLDOWN, (Comparable)Integer.valueOf(cooldown - 1))).m_61124_((Property)FULL, (Comparable)Boolean.valueOf(true))).m_61124_((Property)this.bottles[i], (Comparable)items.get(itemStack.m_41720_())), 3);
                } else {
                    world.m_7731_(pos, (BlockState)((BlockState)blockstate.m_61124_((Property)COOLDOWN, (Comparable)Integer.valueOf(cooldown - 1))).m_61124_((Property)this.bottles[i], (Comparable)items.get(itemStack.m_41720_())), 3);
                }
            } else if (i == 3) {
                world.m_7731_(pos, (BlockState)((BlockState)blockstate.m_61124_((Property)FULL, (Comparable)Boolean.valueOf(true))).m_61124_((Property)this.bottles[i], (Comparable)items.get(itemStack.m_41720_())), 3);
            } else {
                world.m_7731_(pos, (BlockState)blockstate.m_61124_((Property)this.bottles[i], (Comparable)items.get(itemStack.m_41720_())), 3);
            }
            if (player != null && !player.m_150110_().f_35937_) {
                if (itemStack.m_150930_(Items.f_151055_)) {
                    ItemStack setstack = new ItemStack((ItemLike)Items.f_42446_);
                    setstack.m_41764_(1);
                    ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)setstack);
                }
                itemStack.m_41764_(itemStack.m_41613_() - 1);
            }
            return true;
        }
        return false;
    }

    public boolean autoLoad(Level world, BlockPos pos, BlockState blockstate) {
        InjectorBlockEntity _injectorBlockEntity;
        InjectorBlockEntity injector;
        NonNullList<ItemStack> itemLoad;
        ItemStack itemStack;
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof InjectorBlockEntity && !(itemStack = (ItemStack)(itemLoad = (injector = (_injectorBlockEntity = (InjectorBlockEntity)blockEntity)).getLoadItems()).get(0)).m_41619_() && this.load(world, pos, blockstate, itemStack, null, true)) {
            injector.clearItems();
            return true;
        }
        return false;
    }

    public void m_141947_(Level world, BlockPos pos, BlockState blockstate, Entity entity) {
        super.m_141947_(world, pos, blockstate, entity);
        this.stepOnInjector(world, pos, blockstate, entity);
    }

    public void stepOnInjector(Level world, BlockPos pos, BlockState blockstate, Entity entity) {
        if ((Integer)blockstate.m_61143_((Property)COOLDOWN) == 0 && entity instanceof LivingEntity) {
            LivingEntity _living;
            LivingEntity livingEntity = _living = (LivingEntity)entity;
            for (int i = 3; i >= 0; --i) {
                if ((Integer)blockstate.m_61143_((Property)this.bottles[i]) == 0) continue;
                if (i == 3) {
                    world.m_7731_(pos, (BlockState)((BlockState)((BlockState)blockstate.m_61124_((Property)this.bottles[i], (Comparable)Integer.valueOf(0))).m_61124_((Property)FULL, (Comparable)Boolean.valueOf(false))).m_61124_((Property)COOLDOWN, (Comparable)Integer.valueOf(2)), 3);
                } else {
                    world.m_7731_(pos, (BlockState)((BlockState)blockstate.m_61124_((Property)this.bottles[i], (Comparable)Integer.valueOf(0))).m_61124_((Property)COOLDOWN, (Comparable)Integer.valueOf(2)), 3);
                }
                this.releaseInjector(world, pos, blockstate, livingEntity, (Integer)blockstate.m_61143_((Property)this.bottles[i]));
                break;
            }
        }
    }

    public void releaseInjector(Level world, BlockPos pos, BlockState blockstate, LivingEntity entity, int value) {
        double x = (double)pos.m_123341_() + 0.5;
        double y = (double)pos.m_123342_() + 1.5;
        double z = (double)pos.m_123343_() + 0.5;
        if (world instanceof ServerLevel) {
            ServerLevel _level;
            ServerLevel server = _level = (ServerLevel)world;
            this.spawnAreaEffectCloud((Level)server, value, x, y - 0.5, z);
            if (value == 1) {
                world.m_5594_(null, pos, SoundEvents.f_11874_, SoundSource.BLOCKS, 1.0f, 1.0f);
                server.m_8767_((ParticleOptions)ParticleTypes.f_123756_, x, y, z, 100, 0.0, 1.0, 0.0, 1.0);
                entity.m_7292_(new MobEffectInstance((MobEffect)SonaMobEffects.IGNITION.get(), 140, 3));
            } else if (value == 2) {
                world.m_5594_(null, pos, SoundEvents.f_144200_, SoundSource.BLOCKS, 1.0f, 1.0f);
                server.m_8767_((ParticleOptions)ParticleTypes.f_175821_, x, y, z, 500, 0.0, 0.5, 0.0, 0.1);
                entity.m_7292_(new MobEffectInstance((MobEffect)SonaMobEffects.FROST.get(), 140, 3));
            } else if (value == 3) {
                world.m_5594_(null, pos, (SoundEvent)ZombieKitSounds.acid_spray.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                server.m_8767_((ParticleOptions)this.nitricAcid, x, y, z, 500, 0.2, 0.5, 0.2, 0.1);
                entity.m_7292_(new MobEffectInstance((MobEffect)SonaMobEffects.CORROSION.get(), 400, 2));
            } else if (value == 4) {
                world.m_5594_(null, pos, (SoundEvent)ZombieKitSounds.acid_spray.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                server.m_8767_((ParticleOptions)ParticleTypes.f_175826_, x, y, z, 100, 0.0, 0.5, 0.0, 0.1);
                entity.m_7292_(new MobEffectInstance(MobEffects.f_19619_, 1200, 0));
                entity.m_7292_(new MobEffectInstance((MobEffect)SonaMobEffects.CONFUSION.get(), 90, 0));
            } else if (value == 5) {
                world.m_5594_(null, pos, SoundEvents.f_12384_, SoundSource.BLOCKS, 1.0f, 1.0f);
                server.m_8767_((ParticleOptions)ParticleTypes.f_123753_, x, y, z, 500, 0.0, 0.5, 0.0, 0.1);
                entity.m_7292_(new MobEffectInstance((MobEffect)SonaMobEffects.SLIMINESS.get(), 600, 0));
            }
        }
    }

    public void spawnAreaEffectCloud(Level world, int value, double x, double y, double z) {
        AreaEffectCloud areaEffectCloud = new AreaEffectCloud(world, x, y, z);
        areaEffectCloud.m_19712_(0.5f);
        areaEffectCloud.m_19734_(60);
        areaEffectCloud.m_19738_((1.5f - areaEffectCloud.m_19743_()) / (float)areaEffectCloud.m_19748_());
        if (value == 1) {
            areaEffectCloud.m_19724_((ParticleOptions)ParticleTypes.f_123744_);
            areaEffectCloud.m_19716_(new MobEffectInstance((MobEffect)SonaMobEffects.IGNITION.get(), 140, 3));
        } else if (value == 2) {
            areaEffectCloud.m_19724_((ParticleOptions)ParticleTypes.f_175821_);
            areaEffectCloud.m_19716_(new MobEffectInstance((MobEffect)SonaMobEffects.FROST.get(), 140, 3));
        } else if (value == 3) {
            areaEffectCloud.m_19724_((ParticleOptions)this.nitricAcid);
            areaEffectCloud.m_19716_(new MobEffectInstance((MobEffect)SonaMobEffects.CORROSION.get(), 400, 2));
        } else if (value == 4) {
            areaEffectCloud.m_19724_((ParticleOptions)ParticleTypes.f_175826_);
            areaEffectCloud.m_19716_(new MobEffectInstance(MobEffects.f_19619_, 1200, 0));
            areaEffectCloud.m_19716_(new MobEffectInstance((MobEffect)SonaMobEffects.CONFUSION.get(), 90, 0));
        } else if (value == 5) {
            areaEffectCloud.m_19724_((ParticleOptions)ParticleTypes.f_123753_);
            areaEffectCloud.m_19716_(new MobEffectInstance((MobEffect)SonaMobEffects.SLIMINESS.get(), 600, 0));
        }
        world.m_7967_((Entity)areaEffectCloud);
    }

    public void m_213897_(BlockState blockstate, ServerLevel world, BlockPos pos, RandomSource random) {
        super.m_213897_(blockstate, world, pos, random);
        int cooldown = (Integer)blockstate.m_61143_((Property)COOLDOWN);
        if (!((Boolean)blockstate.m_61143_((Property)FULL)).booleanValue()) {
            if (!this.autoLoad((Level)world, pos, blockstate) && cooldown > 0) {
                world.m_7731_(pos, (BlockState)blockstate.m_61124_((Property)COOLDOWN, (Comparable)Integer.valueOf(cooldown - 1)), 3);
            }
        } else if (cooldown > 0) {
            world.m_7731_(pos, (BlockState)blockstate.m_61124_((Property)COOLDOWN, (Comparable)Integer.valueOf(cooldown - 1)), 3);
        }
        world.m_186460_(pos, (Block)this, 20);
    }

    public void m_6807_(BlockState blockstate, Level world, BlockPos pos, BlockState oldState, boolean moving) {
        super.m_6807_(blockstate, world, pos, oldState, moving);
        world.m_186460_(pos, (Block)this, 20);
    }

    public boolean m_7420_(BlockState state, BlockGetter reader, BlockPos pos) {
        return true;
    }

    public int m_7753_(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return 0;
    }

    public VoxelShape m_5909_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.m_83040_();
    }

    public boolean canHarvestBlock(BlockState state, BlockGetter world, BlockPos pos, Player player) {
        Item item = player.m_150109_().m_36056_().m_41720_();
        if (item instanceof PickaxeItem) {
            PickaxeItem tieredItem = (PickaxeItem)item;
            return tieredItem.m_43314_().m_6604_() >= 0;
        }
        return false;
    }

    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder builder) {
        List dropsOriginal = super.m_49635_(state, builder);
        if (!dropsOriginal.isEmpty()) {
            return dropsOriginal;
        }
        return Collections.singletonList(new ItemStack((ItemLike)this, 1));
    }

    public MenuProvider m_7246_(BlockState state, Level worldIn, BlockPos pos) {
        MenuProvider menuProvider;
        BlockEntity tileEntity = worldIn.m_7702_(pos);
        return tileEntity instanceof MenuProvider ? (menuProvider = (MenuProvider)tileEntity) : null;
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new InjectorBlockEntity(pos, state);
    }

    public boolean m_8133_(BlockState state, Level world, BlockPos pos, int eventID, int eventParam) {
        super.m_8133_(state, world, pos, eventID, eventParam);
        BlockEntity blockEntity = world.m_7702_(pos);
        return blockEntity != null && blockEntity.m_7531_(eventID, eventParam);
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.m_60734_() != newState.m_60734_()) {
            BlockEntity blockEntity = world.m_7702_(pos);
            if (blockEntity instanceof InjectorBlockEntity) {
                InjectorBlockEntity be = (InjectorBlockEntity)blockEntity;
                Containers.m_19002_((Level)world, (BlockPos)pos, (Container)be);
                world.m_46717_(pos, (Block)this);
            }
            super.m_6810_(state, world, pos, newState, isMoving);
        }
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState blockState, Level world, BlockPos pos) {
        BlockEntity tileentity = world.m_7702_(pos);
        if (tileentity instanceof InjectorBlockEntity) {
            InjectorBlockEntity be = (InjectorBlockEntity)tileentity;
            return AbstractContainerMenu.m_38938_((Container)be);
        }
        return 0;
    }
}

