/*
 * Decompiled with CFR 0.152.
 */
package com.scarasol.zombiekit.block;

import com.scarasol.zombiekit.config.CommonConfig;
import com.scarasol.zombiekit.init.ZombieKitItems;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.function.ToIntFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ChargerBlock
extends Block {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final BooleanProperty HAS_BATTERY = BooleanProperty.m_61465_((String)"has_battery");
    public static final BooleanProperty RED_STONE_CONNECTED = BooleanProperty.m_61465_((String)"red_stone_connected");
    public static final IntegerProperty BATTERY_POWER = IntegerProperty.m_61631_((String)"battery_power", (int)0, (int)100);

    public ChargerBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)HAS_BATTERY, (Comparable)Boolean.valueOf(false))).m_61124_((Property)RED_STONE_CONNECTED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)BATTERY_POWER, (Comparable)Integer.valueOf(0)));
    }

    public void m_5871_(ItemStack itemstack, BlockGetter world, List<Component> list, TooltipFlag flag) {
        super.m_5871_(itemstack, world, list, flag);
        list.add((Component)Component.m_237115_((String)"block.zombiekit.charger.description_1"));
        list.add((Component)Component.m_237115_((String)"block.zombiekit.charger.description_2"));
    }

    public boolean m_7420_(BlockState state, BlockGetter reader, BlockPos pos) {
        return true;
    }

    public static ToIntFunction<BlockState> getLightLevel(int light) {
        return blockState -> (Boolean)blockState.m_61143_((Property)HAS_BATTERY) != false && (Boolean)blockState.m_61143_((Property)RED_STONE_CONNECTED) != false && (Integer)blockState.m_61143_((Property)BATTERY_POWER) < 100 ? 8 : 0;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
        builder.m_61104_(new Property[]{HAS_BATTERY});
        builder.m_61104_(new Property[]{RED_STONE_CONNECTED});
        builder.m_61104_(new Property[]{BATTERY_POWER});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter world, BlockPos pos, Direction side) {
        return true;
    }

    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder builder) {
        List dropsOriginal = super.m_49635_(state, builder);
        if (!dropsOriginal.isEmpty()) {
            return dropsOriginal;
        }
        if (((Boolean)state.m_61143_((Property)HAS_BATTERY)).booleanValue()) {
            ItemStack itemStack = new ItemStack((ItemLike)ZombieKitItems.BATTERY.get(), 1);
            itemStack.m_41721_(100 - (Integer)state.m_61143_((Property)BATTERY_POWER));
            return Arrays.asList(new ItemStack((ItemLike)this, 1), itemStack);
        }
        return Collections.singletonList(new ItemStack((ItemLike)this, 1));
    }

    public InteractionResult m_6227_(BlockState blockState, Level world, BlockPos pos, Player entity, InteractionHand hand, BlockHitResult hit) {
        super.m_6227_(blockState, world, pos, entity, hand, hit);
        if (!((Boolean)blockState.m_61143_((Property)HAS_BATTERY)).booleanValue() && entity.m_21206_().m_41720_() == ZombieKitItems.WRENCH.get() && entity.m_21205_().m_41720_() == ZombieKitItems.BATTERY.get()) {
            world.m_7731_(pos, (BlockState)((BlockState)blockState.m_61124_((Property)HAS_BATTERY, (Comparable)Boolean.valueOf(true))).m_61124_((Property)BATTERY_POWER, (Comparable)Integer.valueOf(100 - entity.m_21205_().m_41773_())), 3);
            if (!entity.m_7500_()) {
                entity.m_21205_().m_41774_(1);
            }
            return InteractionResult.SUCCESS;
        }
        if (((Boolean)blockState.m_61143_((Property)HAS_BATTERY)).booleanValue() && entity.m_21206_().m_41720_() == ZombieKitItems.WRENCH.get()) {
            ItemStack itemStack = new ItemStack((ItemLike)ZombieKitItems.BATTERY.get(), 1);
            itemStack.m_41721_(100 - (Integer)blockState.m_61143_((Property)BATTERY_POWER));
            ItemEntity itemEntity = new ItemEntity(world, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), itemStack);
            itemEntity.m_32010_(10);
            world.m_7967_((Entity)itemEntity);
            world.m_7731_(pos, (BlockState)((BlockState)blockState.m_61124_((Property)HAS_BATTERY, (Comparable)Boolean.valueOf(false))).m_61124_((Property)BATTERY_POWER, (Comparable)Integer.valueOf(0)), 3);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void m_6861_(BlockState blockstate, Level world, BlockPos pos, Block neighborBlock, BlockPos fromPos, boolean moving) {
        world.m_7731_(pos, (BlockState)blockstate.m_61124_((Property)RED_STONE_CONNECTED, (Comparable)Boolean.valueOf(world.m_277086_(pos) > 0)), 3);
        super.m_6861_(blockstate, world, pos, neighborBlock, fromPos, moving);
    }

    public void m_6807_(BlockState blockstate, Level world, BlockPos pos, BlockState oldState, boolean moving) {
        super.m_6807_(blockstate, world, pos, oldState, moving);
        world.m_186460_(pos, (Block)this, ((Integer)CommonConfig.CHARGING_RATE.get()).intValue());
    }

    public void m_213897_(BlockState blockState, ServerLevel level, BlockPos blockPos, RandomSource random) {
        super.m_213897_(blockState, level, blockPos, random);
        if (((Boolean)blockState.m_61143_((Property)HAS_BATTERY)).booleanValue() && ((Boolean)blockState.m_61143_((Property)RED_STONE_CONNECTED)).booleanValue()) {
            int power = (Integer)blockState.m_61143_((Property)BATTERY_POWER);
            level.m_7731_(blockPos, (BlockState)blockState.m_61124_((Property)BATTERY_POWER, (Comparable)Integer.valueOf(Math.min(power + 1, 100))), 3);
        }
        level.m_186460_(blockPos, (Block)this, ((Integer)CommonConfig.CHARGING_RATE.get()).intValue());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void animateTick(BlockState blockState, Level level, BlockPos blockPos, Random random) {
        if (((Boolean)blockState.m_61143_((Property)HAS_BATTERY)).booleanValue() && ((Boolean)blockState.m_61143_((Property)RED_STONE_CONNECTED)).booleanValue() && (Integer)blockState.m_61143_((Property)BATTERY_POWER) < 100) {
            double d0 = (double)blockPos.m_123341_() + 0.5 + (random.nextDouble() - 0.5) * 0.2;
            double d1 = (double)blockPos.m_123342_() + 0.7 + (random.nextDouble() - 0.5) * 0.2;
            double d2 = (double)blockPos.m_123343_() + 0.5 + (random.nextDouble() - 0.5) * 0.2;
            level.m_7106_((ParticleOptions)DustParticleOptions.f_123656_, d0, d1, d2, 0.0, 0.0, 0.0);
        }
    }
}

