/*
 * Decompiled with CFR 0.152.
 */
package com.scarasol.zombiekit.block;

import com.scarasol.zombiekit.config.CommonConfig;
import com.scarasol.zombiekit.init.ZombieKitBlocks;
import com.scarasol.zombiekit.init.ZombieKitDamageTypes;
import com.scarasol.zombiekit.init.ZombieKitItems;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BarbedWireBlock
extends Block {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final IntegerProperty STAGE = IntegerProperty.m_61631_((String)"stage", (int)0, (int)2);

    public BarbedWireBlock(BlockBehaviour.Properties properties, int stage) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)STAGE, (Comparable)Integer.valueOf(stage)));
    }

    public boolean m_7420_(BlockState state, BlockGetter reader, BlockPos pos) {
        return true;
    }

    public int m_7753_(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return 0;
    }

    public VoxelShape m_5909_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.m_83040_();
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
        builder.m_61104_(new Property[]{STAGE});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        return state.m_60717_(mirrorIn.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockPathTypes getBlockPathType(BlockState state, BlockGetter world, BlockPos pos, Mob entity) {
        return BlockPathTypes.WALKABLE;
    }

    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder builder) {
        return switch ((Integer)state.m_61143_((Property)STAGE)) {
            case 1 -> Collections.singletonList(new ItemStack((ItemLike)ZombieKitItems.BARBED_WIRE_BROKEN.get(), 1));
            case 2 -> Collections.singletonList(new ItemStack((ItemLike)ZombieKitItems.BARBED_WIRE_EXTREMELY_BROKEN.get(), 1));
            default -> Collections.singletonList(new ItemStack((ItemLike)ZombieKitItems.BARBED_WIRE.get(), 1));
        };
    }

    public void m_7892_(BlockState blockstate, Level world, BlockPos pos, Entity entity) {
        Player player;
        super.m_7892_(blockstate, world, pos, entity);
        switch ((Integer)blockstate.m_61143_((Property)STAGE)) {
            case 0: {
                entity.m_7601_(Blocks.f_50016_.m_49966_(), new Vec3(0.25, 0.05, 0.25));
                break;
            }
            case 1: {
                entity.m_7601_(Blocks.f_50016_.m_49966_(), new Vec3(0.525, 0.4, 0.525));
                break;
            }
            case 2: {
                entity.m_7601_(Blocks.f_50016_.m_49966_(), new Vec3(0.8, 0.75, 0.8));
            }
        }
        double x = Math.abs(entity.m_20185_() - entity.f_19790_);
        double y = Math.abs(entity.m_20189_() - entity.f_19792_);
        double z = Math.abs(entity.m_20186_() - entity.f_19791_);
        if ((x >= 0.003 || y >= 0.003 || z >= 0.003) && (!(entity instanceof Player) || !(player = (Player)entity).m_7500_()) && entity.m_6084_()) {
            entity.m_6469_(ZombieKitDamageTypes.damageSource(entity.m_9236_().m_9598_(), ZombieKitDamageTypes.BARBED_WIRE), 1.0f);
            if (world.m_213780_().m_188500_() < (Double)CommonConfig.BROKEN_CHANCE.get()) {
                this.breakBarbedWire(world, blockstate, pos);
            }
        }
    }

    public InteractionResult m_6227_(BlockState blockstate, Level world, BlockPos pos, Player entity, InteractionHand hand, BlockHitResult hit) {
        super.m_6227_(blockstate, world, pos, entity, hand, hit);
        if (this.fixBarbedWire(world, blockstate, pos, entity)) {
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void breakBarbedWire(Level level, BlockState blockState, BlockPos blockPos) {
        if (level.m_5776_()) {
            return;
        }
        int stage = (Integer)blockState.m_61143_((Property)STAGE);
        switch (stage) {
            case 0: {
                level.m_7731_(blockPos, (BlockState)((Block)ZombieKitBlocks.BARBED_WIRE_BROKEN.get()).m_49966_().m_61124_((Property)FACING, (Comparable)((Direction)blockState.m_61143_((Property)FACING))), 3);
                break;
            }
            case 1: {
                level.m_7731_(blockPos, (BlockState)((Block)ZombieKitBlocks.BARBED_WIRE_EXTREMELY_BROKEN.get()).m_49966_().m_61124_((Property)FACING, (Comparable)((Direction)blockState.m_61143_((Property)FACING))), 3);
                break;
            }
            case 2: {
                level.m_46961_(blockPos, false);
            }
        }
    }

    public boolean fixBarbedWire(Level level, BlockState blockState, BlockPos blockPos, Player player) {
        int stage = (Integer)blockState.m_61143_((Property)STAGE);
        if (stage == 0 || player.m_21205_().m_41720_() != ZombieKitItems.IRON_WIRE.get() || player.m_21206_().m_41720_() != ZombieKitItems.WRENCH.get()) {
            return false;
        }
        switch (stage) {
            case 1: {
                level.m_7731_(blockPos, ((Block)ZombieKitBlocks.BARBED_WIRE.get()).m_49966_(), 3);
                break;
            }
            case 2: {
                level.m_7731_(blockPos, ((Block)ZombieKitBlocks.BARBED_WIRE_BROKEN.get()).m_49966_(), 3);
            }
        }
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123749_, (double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_(), 10, 0.2, 0.2, 0.2, 0.05);
        }
        if (!player.m_7500_()) {
            player.m_21205_().m_41774_(1);
        }
        return true;
    }
}

