/*
 * Decompiled with CFR 0.152.
 */
package com.scarasol.sona.util;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;

public class SonaMath {
    public static double parabolaAngleCalculate(LivingEntity entity, BlockPos target, double v) {
        return SonaMath.parabolaAngleCalculate(entity, Vec3.m_82512_((Vec3i)target), v);
    }

    public static double parabolaAngleCalculate(LivingEntity entity, LivingEntity target, double v) {
        return SonaMath.parabolaAngleCalculate(entity, target.m_20182_().m_82520_(0.0, (double)target.m_20192_(), 0.0), v);
    }

    public static double parabolaAngleCalculate(LivingEntity entity, Vec3 target, double v) {
        double t2;
        double g;
        Vec3 position = entity.m_20182_().m_82520_(0.0, (double)entity.m_20192_(), 0.0);
        double x = Math.pow(Math.pow(target.m_7096_() - position.m_7096_(), 2.0) + Math.pow(target.m_7094_() - position.m_7094_(), 2.0), 0.5);
        double y = target.m_7098_() - position.m_7098_();
        double delta = Math.pow(y * (g = 0.05) - v * v, 2.0) - g * g * (x * x + y * y);
        if (delta < 0.0) {
            return -1.0;
        }
        double t1 = (v * v - y * g + Math.pow(delta, 0.5)) / (0.5 * g * g);
        double t = Math.max(t1, t2 = (v * v - y * g - Math.pow(delta, 0.5)) / (0.5 * g * g));
        if (t < 0.0) {
            return -1.0;
        }
        double cos = x / (v * (t = Math.pow(t, 0.5)));
        double angle = Math.acos(cos);
        return angle < 1.5707963267948966 ? angle : -1.0;
    }

    public static double parabolaXDistanceCalculate(double angle, double v) {
        double vY = v * Math.sin(Math.toRadians(angle));
        double vX = v * Math.cos(Math.toRadians(angle));
        double g = 0.05;
        double t = 2.0 * vY / g;
        return vX * t;
    }

    public static Vec3 parabolaDropPointCalculate(double v, Entity entity) {
        Vec3 pos = entity.m_20182_();
        Vec3 currentV = entity.m_20154_().m_82490_(v);
        double g = 0.05;
        while (true) {
            Vec3 lastPos = pos;
            pos = pos.m_82549_(currentV);
            Vec3 checkV = currentV.m_82541_();
            int i = 0;
            while ((double)i < v) {
                lastPos = lastPos.m_82549_(checkV);
                if (!entity.m_9236_().m_46749_(BlockPos.m_274446_((Position)lastPos)) || !entity.m_9236_().m_8055_(BlockPos.m_274446_((Position)lastPos)).m_60795_()) {
                    return lastPos;
                }
                ++i;
            }
            currentV = currentV.m_82520_(0.0, -g, 0.0);
        }
    }

    public static double vectorDegreeCalculate(Vec3 vec1, Vec3 vec2) {
        double cos = vec1.m_82526_(vec2) / vec1.m_82553_() / vec2.m_82553_();
        return Math.toDegrees(Math.acos(cos));
    }
}

