/*
 * Decompiled with CFR 0.152.
 */
package com.scarasol.sona.network;

import com.scarasol.sona.manager.ChatManager;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class SyncChatPacket {
    private final String chatIncreaseItem;
    private final int chatRange;
    private final boolean chatLimit;

    public SyncChatPacket(String chatIncreaseItem, int chatRange, boolean chatLimit) {
        this.chatIncreaseItem = chatIncreaseItem;
        this.chatRange = chatRange;
        this.chatLimit = chatLimit;
    }

    public String getChatIncreaseItem() {
        return this.chatIncreaseItem;
    }

    public int getChatRange() {
        return this.chatRange;
    }

    public boolean isChatLimit() {
        return this.chatLimit;
    }

    public static SyncChatPacket decode(FriendlyByteBuf buf) {
        return new SyncChatPacket(new String(buf.m_130052_()), buf.readInt(), buf.readBoolean());
    }

    public static void encode(SyncChatPacket msg, FriendlyByteBuf buf) {
        buf.m_130087_(msg.getChatIncreaseItem().getBytes());
        buf.writeInt(msg.getChatRange());
        buf.writeBoolean(msg.isChatLimit());
    }

    public static void handler(SyncChatPacket msg, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            if (msg != null) {
                ((NetworkEvent.Context)context.get()).enqueueWork(() -> SyncChatPacket.lambda$handler$0((Supplier)context, msg));
            }
        });
        context.get().setPacketHandled(true);
    }

    private static /* synthetic */ void lambda$handler$0(Supplier context, SyncChatPacket msg) {
        if (!((NetworkEvent.Context)context.get()).getDirection().getReceptionSide().isServer()) {
            ChatManager.addRangeItem(msg.chatIncreaseItem);
            ChatManager.setChatRange(msg.chatRange);
            ChatManager.setChatLimit(msg.chatLimit);
        }
    }
}

