/*
 * Decompiled with CFR 0.152.
 */
package com.scarasol.sona.network;

import com.scarasol.sona.manager.SoundManager;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;

public class SoundDecoyPacket {
    private final double x;
    private final double y;
    private final double z;
    private final int amplifier;

    public SoundDecoyPacket(double x, double y, double z, int amplifier) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.amplifier = amplifier;
    }

    public static SoundDecoyPacket decode(FriendlyByteBuf buf) {
        return new SoundDecoyPacket(buf.readDouble(), buf.readDouble(), buf.readDouble(), buf.readInt());
    }

    public static void encode(SoundDecoyPacket msg, FriendlyByteBuf buf) {
        buf.writeDouble(msg.x);
        buf.writeDouble(msg.y);
        buf.writeDouble(msg.z);
        buf.writeInt(msg.amplifier);
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public int getAmplifier() {
        return this.amplifier;
    }

    public static void handler(SoundDecoyPacket msg, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            if (msg != null) {
                ((NetworkEvent.Context)context.get()).enqueueWork(() -> SoundDecoyPacket.lambda$handler$0((Supplier)context, msg));
            }
        });
        context.get().setPacketHandled(true);
    }

    private static /* synthetic */ void lambda$handler$0(Supplier context, SoundDecoyPacket msg) {
        ServerPlayer player;
        if (((NetworkEvent.Context)context.get()).getDirection().getReceptionSide().isServer() && (player = ((NetworkEvent.Context)context.get()).getSender()) != null) {
            SoundManager.spawnSoundDecoy(player.m_9236_(), msg.getX(), msg.getY(), msg.getZ(), msg.getAmplifier());
        }
    }
}

