/*
 * Decompiled with CFR 0.152.
 */
package com.scarasol.sona.network;

import com.scarasol.sona.manager.RotManager;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class RotPacket {
    private final double rotValue;
    private final int slotInt;
    private final boolean isInventory;

    public RotPacket(double rotValue, int slotInt, boolean isInventory) {
        this.rotValue = rotValue;
        this.slotInt = slotInt;
        this.isInventory = isInventory;
    }

    public static RotPacket decode(FriendlyByteBuf buf) {
        return new RotPacket(buf.readDouble(), buf.readInt(), buf.readBoolean());
    }

    public static void encode(RotPacket msg, FriendlyByteBuf buf) {
        buf.writeDouble(msg.rotValue);
        buf.writeInt(msg.slotInt);
        buf.writeBoolean(msg.isInventory);
    }

    public double getRotValue() {
        return this.rotValue;
    }

    public int getSlotInt() {
        return this.slotInt;
    }

    public boolean isInventory() {
        return this.isInventory;
    }

    public static void handler(RotPacket msg, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            if (msg != null) {
                ((NetworkEvent.Context)context.get()).enqueueWork(() -> RotPacket.lambda$handler$0((Supplier)context, msg));
            }
        });
        context.get().setPacketHandled(true);
    }

    private static /* synthetic */ void lambda$handler$0(Supplier context, RotPacket msg) {
        if (!((NetworkEvent.Context)context.get()).getDirection().getReceptionSide().isServer()) {
            ItemStack itemStack = msg.isInventory() ? Minecraft.m_91087_().f_91074_.m_150109_().m_8020_(msg.getSlotInt()) : ((Slot)Minecraft.m_91087_().f_91074_.f_36096_.f_38839_.get(msg.getSlotInt())).m_7993_();
            RotManager.putRot(itemStack, msg.getRotValue());
            if (!msg.isInventory()) {
                ((Slot)Minecraft.m_91087_().f_91074_.f_36096_.f_38839_.get(msg.getSlotInt())).m_6654_();
            }
        }
    }
}

