/*
 * Decompiled with CFR 0.152.
 */
package com.scarasol.sona.network;

import com.scarasol.sona.accessor.IBaseContainerBlockEntityAccessor;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.network.NetworkEvent;

public class LockPacket {
    private final BlockPos blockPos;
    private final UUID lockCode;
    private final boolean locked;

    public LockPacket(BlockPos blockPos, UUID lockCode, boolean locked) {
        this.blockPos = blockPos;
        this.lockCode = lockCode;
        this.locked = locked;
    }

    public BlockPos getBlockPos() {
        return this.blockPos;
    }

    public UUID getLockCode() {
        return this.lockCode;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public static LockPacket decode(FriendlyByteBuf buf) {
        return new LockPacket(buf.m_130135_(), buf.m_130259_(), buf.readBoolean());
    }

    public static void encode(LockPacket msg, FriendlyByteBuf buf) {
        buf.m_130064_(msg.blockPos);
        buf.m_130077_(msg.lockCode);
        buf.writeBoolean(msg.locked);
    }

    public static void handler(LockPacket msg, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            if (msg != null) {
                ((NetworkEvent.Context)context.get()).enqueueWork(() -> LockPacket.lambda$handler$0((Supplier)context, msg));
            }
        });
        context.get().setPacketHandled(true);
    }

    private static /* synthetic */ void lambda$handler$0(Supplier context, LockPacket msg) {
        ServerPlayer player;
        if (((NetworkEvent.Context)context.get()).getDirection().getReceptionSide().isServer() && (player = ((NetworkEvent.Context)context.get()).getSender()) != null) {
            Level level = player.m_9236_();
            BlockEntity blockEntity = level.m_7702_(msg.getBlockPos());
            BlockState blockState = level.m_8055_(msg.getBlockPos());
            if (blockEntity instanceof IBaseContainerBlockEntityAccessor) {
                IBaseContainerBlockEntityAccessor baseContainerBlockEntity = (IBaseContainerBlockEntityAccessor)blockEntity;
                if (!blockEntity.getPersistentData().m_128441_("flag")) {
                    if (msg.isLocked()) {
                        baseContainerBlockEntity.lockContainer(blockEntity.getPersistentData(), msg.getLockCode());
                    }
                    blockEntity.getPersistentData().m_128379_("LockFlag", true);
                    level.m_7260_(msg.getBlockPos(), blockState, blockState, 3);
                }
            }
        }
    }
}

