/*
 * Decompiled with CFR 0.152.
 */
package com.scarasol.sona.mixin;

import com.scarasol.sona.configuration.CommonConfig;
import com.scarasol.sona.manager.RotManager;
import com.scarasol.sona.manager.RustManager;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import java.util.List;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={LootTable.class})
public abstract class LootTableMixin {
    @Inject(method={"fill"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/Container;setItem(ILnet/minecraft/world/item/ItemStack;)V")}, locals=LocalCapture.CAPTURE_FAILSOFT)
    private void onFill(Container container, LootParams lootParams, long p_287585_, CallbackInfo ci, LootContext lootcontext, ObjectArrayList objectarraylist, RandomSource random, List list, ObjectListIterator var9, ItemStack itemStack) {
        if (((Boolean)CommonConfig.ROT_OPEN.get()).booleanValue() && container instanceof BlockEntity) {
            BlockEntity entity = (BlockEntity)container;
            if (itemStack.m_41614_() && RotManager.canBeRotten(itemStack)) {
                long day = entity.m_58904_().m_46468_() / 24000L;
                double multiplier = 5.0 * (double)day / ((double)day + 12.0) * RotManager.getMultiplier(itemStack);
                if (random.m_188500_() < (Double)CommonConfig.WARPED_CHANCE.get()) {
                    multiplier *= ((Double)CommonConfig.WARPED_WEIGHT.get()).doubleValue();
                    RotManager.putWarp(itemStack, true);
                }
                RotManager.putRot(itemStack, random.m_188500_() * 20.0 * Math.max(multiplier, 0.0));
            }
        }
        if (((Boolean)CommonConfig.RUST_OPEN.get()).booleanValue() && RustManager.canBeRust(itemStack)) {
            if (random.m_188500_() < 0.2) {
                RustManager.putWaxed(itemStack, random.m_188503_(((Integer)CommonConfig.WAX_TIMES.get()).intValue()));
            } else {
                RustManager.putRust(itemStack, random.m_188500_() * 100.0);
            }
        }
    }
}

