/*
 * Decompiled with CFR 0.152.
 */
package com.scarasol.sona.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.scarasol.sona.accessor.ILivingEntityAccessor;
import com.scarasol.sona.configuration.CommonConfig;
import com.scarasol.sona.effect.PhysicalEffect;
import com.scarasol.sona.init.SonaMobEffects;
import com.scarasol.sona.manager.InfectionManager;
import com.scarasol.sona.manager.InjuryManager;
import com.scarasol.sona.manager.SoundManager;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin
extends Entity
implements ILivingEntityAccessor {
    @Unique
    private static final EntityDataAccessor<Float> INFECTION_LEVEL = SynchedEntityData.m_135353_(LivingEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    @Unique
    private static final EntityDataAccessor<Float> INJURY_LEVEL = SynchedEntityData.m_135353_(LivingEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    @Unique
    private static final EntityDataAccessor<Float> BANDAGE_LEVEL = SynchedEntityData.m_135353_(LivingEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    @Unique
    private final List<MobEffectInstance> physicalEffects = new ArrayList<MobEffectInstance>();

    @Shadow
    public abstract boolean m_7292_(MobEffectInstance var1);

    @Shadow
    public abstract boolean m_21023_(MobEffect var1);

    @Shadow
    public abstract double m_21133_(Attribute var1);

    public LivingEntityMixin(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    @Override
    @Unique
    public void setInfectionLevel(float infectionLevel) {
        this.f_19804_.m_135381_(INFECTION_LEVEL, (Object)Float.valueOf(infectionLevel));
    }

    @Override
    @Unique
    public float getInfectionLevel() {
        return ((Float)this.f_19804_.m_135370_(INFECTION_LEVEL)).floatValue();
    }

    @Override
    @Unique
    public void setInjuryLevel(float injuryLevel) {
        this.f_19804_.m_135381_(INJURY_LEVEL, (Object)Float.valueOf(injuryLevel));
    }

    @Override
    @Unique
    public float getInjuryLevel() {
        return ((Float)this.f_19804_.m_135370_(INJURY_LEVEL)).floatValue();
    }

    @Override
    @Unique
    public void setBandageLevel(float bandageLevel) {
        this.f_19804_.m_135381_(BANDAGE_LEVEL, (Object)Float.valueOf(bandageLevel));
    }

    @Override
    @Unique
    public float getBandageLevel() {
        return ((Float)this.f_19804_.m_135370_(BANDAGE_LEVEL)).floatValue();
    }

    @Inject(method={"defineSynchedData"}, at={@At(value="TAIL")})
    private void onDefineSynchedData(CallbackInfo ci) {
        this.f_19804_.m_135372_(INFECTION_LEVEL, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(INJURY_LEVEL, (Object)Float.valueOf(100.0f));
        this.f_19804_.m_135372_(BANDAGE_LEVEL, (Object)Float.valueOf(0.0f));
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="TAIL")})
    private void onReadAdditionalSaveData(CompoundTag compoundTag, CallbackInfo ci) {
        if (compoundTag.m_128441_("InfectionLevel")) {
            float infectionLevel = compoundTag.m_128457_("InfectionLevel");
            this.setInfectionLevel(infectionLevel);
        }
        if (compoundTag.m_128441_("InjuryLevel")) {
            float injuryLevel = compoundTag.m_128457_("InjuryLevel");
            this.setInjuryLevel(injuryLevel);
        }
        if (compoundTag.m_128441_("BandageLevel")) {
            float bandageLevel = compoundTag.m_128457_("BandageLevel");
            this.setBandageLevel(bandageLevel);
        }
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="TAIL")})
    private void onAddAdditionalSaveData(CompoundTag compoundTag, CallbackInfo ci) {
        compoundTag.m_128350_("InfectionLevel", this.getInfectionLevel());
        compoundTag.m_128350_("InjuryLevel", this.getInjuryLevel());
        compoundTag.m_128350_("BandageLevel", this.getBandageLevel());
    }

    @Inject(method={"removeAllEffects"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;onEffectRemoved(Lnet/minecraft/world/effect/MobEffectInstance;)V")}, locals=LocalCapture.CAPTURE_FAILSOFT)
    public void onRemoveAllEffects(CallbackInfoReturnable<Boolean> cir, Iterator<MobEffectInstance> iterator, boolean flag, MobEffectInstance effect) {
        if (effect.m_19544_() instanceof PhysicalEffect && !((Boolean)CommonConfig.PHYSICAL_EFFECT_REMOVE.get()).booleanValue()) {
            this.physicalEffects.add(effect);
        }
    }

    @WrapOperation(method={"hurt"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/damagesource/DamageSource;getEntity()Lnet/minecraft/world/entity/Entity;")})
    private Entity warpLastHurtMob(DamageSource instance, Operation<Entity> operation) {
        LivingEntity livingEntity;
        Entity entity = instance.m_7639_();
        if (entity instanceof LivingEntity && (livingEntity = (LivingEntity)entity).m_21051_(Attributes.f_22277_) != null && instance.m_269014_() && livingEntity.m_21023_((MobEffect)SonaMobEffects.CAMOUFLAGE.get())) {
            double exposureRange;
            double distance = this.m_20182_().m_82554_(livingEntity.m_20182_());
            if (livingEntity.m_21023_((MobEffect)SonaMobEffects.EXPOSURE.get()) && (exposureRange = this.m_21133_(Attributes.f_22277_) * 0.3 * (double)(livingEntity.m_21124_((MobEffect)SonaMobEffects.EXPOSURE.get()).m_19564_() + 1)) > distance) {
                return (Entity)operation.call(new Object[]{instance});
            }
            double range = this.m_21133_(Attributes.f_22277_) * (1.0 / Math.pow(2.0, livingEntity.m_21124_((MobEffect)SonaMobEffects.CAMOUFLAGE.get()).m_19564_() + 1));
            if (distance > range) {
                return null;
            }
        }
        return (Entity)operation.call(new Object[]{instance});
    }

    @Inject(method={"baseTick"}, at={@At(value="TAIL")})
    private void onBaseTick(CallbackInfo ci) {
        LivingEntityMixin livingEntityMixin;
        if (!this.physicalEffects.isEmpty()) {
            for (MobEffectInstance mobEffectInstance : this.physicalEffects) {
                this.m_7292_(mobEffectInstance);
            }
            this.physicalEffects.clear();
        }
        if ((livingEntityMixin = this) instanceof LivingEntity) {
            Player player;
            boolean bl;
            LivingEntity livingEntity = (LivingEntity)livingEntityMixin;
            boolean bl2 = bl = livingEntity.m_6084_() && (!(livingEntity instanceof Player) || !(player = (Player)livingEntity).m_7500_() && !player.m_5833_());
            if (!this.m_9236_().m_5776_() && bl) {
                if (((Boolean)CommonConfig.INFECTION_OPEN.get()).booleanValue()) {
                    InfectionManager.infectionTick(livingEntity);
                }
                if (((Boolean)CommonConfig.INJURY_OPEN.get()).booleanValue() && bl && livingEntity instanceof Player) {
                    InjuryManager.injuryTick(livingEntity);
                }
                if (livingEntity.m_20142_() && ((Boolean)CommonConfig.SOUND_OPEN.get()).booleanValue() && ((Boolean)CommonConfig.SPRINT_SOUND.get()).booleanValue() && this.m_9236_().m_46467_() % 60L == 0L) {
                    SoundManager.spawnSoundDecoy(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), 0);
                }
            }
        }
    }
}

