/*
 * Decompiled with CFR 0.152.
 */
package com.scarasol.sona.mixin;

import com.scarasol.sona.configuration.CommonConfig;
import com.scarasol.sona.manager.ChatManager;
import com.scarasol.sona.manager.RotManager;
import com.scarasol.sona.manager.RustManager;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.CapabilityProvider;
import net.minecraftforge.common.extensions.IForgeItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ItemStack.class})
public abstract class ItemStackMixin
extends CapabilityProvider<ItemStack>
implements IForgeItemStack {
    @Unique
    private boolean init;

    @Shadow
    public abstract boolean m_41614_();

    @Shadow
    public abstract Item m_41720_();

    protected ItemStackMixin(Class<ItemStack> baseClass) {
        super(baseClass);
    }

    protected ItemStackMixin(Class<ItemStack> baseClass, boolean isLazy) {
        super(baseClass, isLazy);
    }

    @Inject(method={"isSameItemSameTags"}, cancellable=true, at={@At(value="RETURN")})
    private static void OnIsSameItemSameTags(ItemStack itemStack1, ItemStack itemStack2, CallbackInfoReturnable<Boolean> cir) {
        if (!((Boolean)CommonConfig.ROT_STACKABLE.get()).booleanValue() || ((Boolean)cir.getReturnValue()).booleanValue() || !itemStack1.m_41614_() || !itemStack2.m_41614_()) {
            return;
        }
        if (!itemStack1.m_150930_(itemStack2.m_41720_())) {
            return;
        }
        if (ItemStackMixin.tagMatchesIgnoreRot(itemStack1, itemStack2)) {
            cir.setReturnValue((Object)true);
        }
    }

    @Unique
    private static boolean tagMatchesIgnoreRot(Object itemStack11, ItemStack itemStack2) {
        if (itemStack11 instanceof ItemStack) {
            ItemStack itemStack1 = (ItemStack)itemStack11;
            if (itemStack2.m_41720_().m_41472_() && itemStack1.m_41614_()) {
                if (itemStack1.m_41783_() == null && itemStack2.m_41783_() != null) {
                    return itemStack2.m_41783_().m_128431_().size() == ItemStackMixin.tagSize(itemStack2);
                }
                if (itemStack1.m_41783_() != null && itemStack2.m_41783_() == null) {
                    return itemStack1.m_41783_().m_128431_().size() == ItemStackMixin.tagSize(itemStack1);
                }
            }
        }
        return false;
    }

    @Unique
    private static int tagSize(ItemStack itemStack) {
        int size = 0;
        if (itemStack.m_41783_() == null || !itemStack.m_41614_()) {
            return size;
        }
        if (itemStack.m_41783_().m_128441_("RotValue")) {
            ++size;
        }
        if (itemStack.m_41783_().m_128441_("RotSaveTime")) {
            ++size;
        }
        if (itemStack.m_41783_().m_128441_("RotMultiplier")) {
            ++size;
        }
        return size;
    }

    @Inject(method={"inventoryTick"}, at={@At(value="HEAD")})
    private void onInventoryTick(Level level, Entity entity, int slot, boolean selected, CallbackInfo ci) {
        if (!this.init && ChatManager.isChatLimit()) {
            ChatManager.setItemRange((Object)this);
            this.init = true;
        }
        if (level.m_5776_()) {
            return;
        }
        if (((Boolean)CommonConfig.ROT_OPEN.get()).booleanValue()) {
            RotManager.rotTick((Object)this, entity, slot, (double)(((Biome)level.m_204166_(entity.m_20097_()).m_203334_()).m_47554_() / 2.0f) + 0.6);
        }
        if (((Boolean)CommonConfig.RUST_OPEN.get()).booleanValue()) {
            RustManager.changeRustModel((Object)this);
        }
    }

    @Inject(method={"useOn"}, at={@At(value="RETURN")})
    private void useOn(UseOnContext useOnContext, CallbackInfoReturnable<InteractionResult> cir) {
        Player player = useOnContext.m_43723_();
        if (player == null || player.m_5833_() || player.m_7500_()) {
            return;
        }
        if (((Boolean)CommonConfig.RUST_OPEN.get()).booleanValue() && (cir.getReturnValue() == InteractionResult.CONSUME || cir.getReturnValue() == InteractionResult.SUCCESS)) {
            RustManager.rustItem((Object)this, (LivingEntity)player, useOnContext.m_43724_() == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND);
        }
    }

    @Inject(method={"use"}, at={@At(value="RETURN")})
    private void use(Level level, Player player, InteractionHand interactionHand, CallbackInfoReturnable<InteractionResultHolder<ItemStack>> cir) {
        if (player.m_5833_() || player.m_7500_()) {
            return;
        }
        if (((Boolean)CommonConfig.RUST_OPEN.get()).booleanValue() && (((InteractionResultHolder)cir.getReturnValue()).m_19089_() == InteractionResult.CONSUME || ((InteractionResultHolder)cir.getReturnValue()).m_19089_() == InteractionResult.SUCCESS)) {
            RustManager.rustItem((Object)this, (LivingEntity)player, interactionHand == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND);
        }
    }

    @Inject(method={"interactLivingEntity"}, at={@At(value="RETURN")})
    private void onInteractLivingEntity(Player player, LivingEntity livingEntity, InteractionHand interactionHand, CallbackInfoReturnable<InteractionResult> cir) {
        if (player.m_5833_() || player.m_7500_()) {
            return;
        }
        if (((Boolean)CommonConfig.RUST_OPEN.get()).booleanValue() && (cir.getReturnValue() == InteractionResult.CONSUME || cir.getReturnValue() == InteractionResult.SUCCESS)) {
            RustManager.rustItem((Object)this, (LivingEntity)player, interactionHand == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND);
        }
    }

    @Inject(method={"mineBlock"}, at={@At(value="RETURN")})
    private void onMineBlock(Level level, BlockState blockState, BlockPos blockPos, Player player, CallbackInfo ci) {
        if (player.m_5833_() || player.m_7500_()) {
            return;
        }
        if (((Boolean)CommonConfig.RUST_OPEN.get()).booleanValue()) {
            RustManager.rustItem((Object)this, (LivingEntity)player, EquipmentSlot.MAINHAND);
        }
    }

    @Inject(method={"hurtEnemy"}, at={@At(value="RETURN")})
    private void onHurtEnemy(LivingEntity livingEntity, Player player, CallbackInfo ci) {
        if (player.m_5833_() || player.m_7500_()) {
            return;
        }
        if (((Boolean)CommonConfig.RUST_OPEN.get()).booleanValue()) {
            RustManager.rustItem((Object)this, (LivingEntity)player, player.m_21205_().equals((Object)this) ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND);
        }
    }

    @Inject(method={"getDestroySpeed"}, cancellable=true, at={@At(value="RETURN")})
    private void onGetDestroySpeed(BlockState blockState, CallbackInfoReturnable<Float> cir) {
        float speed = ((Float)cir.getReturnValue()).floatValue();
        if (!((Boolean)CommonConfig.RUST_OPEN.get()).booleanValue() || !RustManager.canBeRust((Object)this)) {
            return;
        }
        if (RustManager.getRust((Object)this) >= 75.0) {
            cir.setReturnValue((Object)Float.valueOf(Math.min(1.0f, speed * 0.85f)));
        } else if (RustManager.getRust((Object)this) >= 50.0) {
            cir.setReturnValue((Object)Float.valueOf(Math.min(1.0f, speed * 0.95f)));
        }
    }
}

