/*
 * Decompiled with CFR 0.152.
 */
package com.scarasol.sona.mixin;

import com.scarasol.sona.accessor.IBaseContainerBlockEntityAccessor;
import com.scarasol.sona.configuration.CommonConfig;
import com.scarasol.sona.network.LockPacket;
import com.scarasol.sona.network.NetworkHandler;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.LockCode;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ForgeRegistries;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={BaseContainerBlockEntity.class})
public abstract class BaseContainerBlockEntityMixin
extends BlockEntity
implements IBaseContainerBlockEntityAccessor {
    @Shadow
    private LockCode f_58621_;

    @Shadow
    public abstract Component m_7755_();

    public BaseContainerBlockEntityMixin(BlockEntityType<?> blockEntityType, BlockPos blockPos, BlockState blockState) {
        super(blockEntityType, blockPos, blockState);
    }

    @Override
    @Unique
    public void breakLockKey() {
        if (ForgeRegistries.BLOCK_ENTITY_TYPES.getKey((Object)this.m_58903_()).toString().contains("lootr")) {
            return;
        }
        this.f_58621_ = LockCode.f_19102_;
        this.getPersistentData().m_128473_("Lock");
        if (this.m_58904_() != null) {
            this.m_58904_().m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
        }
    }

    @Override
    @Unique
    public boolean isLocked() {
        return this.f_58621_ != LockCode.f_19102_ || this.getPersistentData().m_128441_("Lock");
    }

    @Override
    @Unique
    public boolean isLocked(Player player) {
        if (ForgeRegistries.BLOCK_ENTITY_TYPES.getKey((Object)this.m_58903_()).toString().contains("lootr")) {
            return this.isLocked() && !this.containsPlayer(player, this.m_187482_().m_128437_("LootrOpeners", 11));
        }
        return this.isLocked();
    }

    @Unique
    public boolean containsPlayer(Player player, ListTag list) {
        UUID uuid = player.m_20148_();
        for (Tag tag : list) {
            if (!uuid.equals(NbtUtils.m_129233_((Tag)tag))) continue;
            return true;
        }
        return false;
    }

    @Override
    @Unique
    public void lockContainer(CompoundTag compoundTag) {
        if (ForgeRegistries.BLOCK_ENTITY_TYPES.getKey((Object)this.m_58903_()).m_135815_().contains("airdrop")) {
            return;
        }
        if (((List)CommonConfig.BLOCK_LOCK_BLACKLIST.get()).contains(ForgeRegistries.BLOCK_ENTITY_TYPES.getKey((Object)this.m_58903_()).toString())) {
            return;
        }
        if (!(!compoundTag.m_128425_("LootTable", 8) || compoundTag.m_128441_("ForgeData") && compoundTag.m_128469_("ForgeData").m_128441_("LockFlag"))) {
            UUID uuid = UUID.randomUUID();
            boolean isLocked = false;
            if (((Boolean)CommonConfig.LOCK_WHITELIST_OPEN.get()).booleanValue() && CommonConfig.findIndex(compoundTag.m_128461_("LootTable"), (List)CommonConfig.LOCK_WHITELIST.get()) == -1) {
                return;
            }
            Random random = new Random();
            if (random.nextDouble() * 100.0 < (Double)CommonConfig.LOCK_PERCENT.get()) {
                isLocked = true;
                this.lockContainer(compoundTag, uuid);
            }
            if (this.m_58904_() != null && this.m_58904_().m_5776_() && ForgeRegistries.BLOCK_ENTITY_TYPES.getKey((Object)this.m_58903_()).toString().contains("lootr")) {
                NetworkHandler.PACKET_HANDLER.sendToServer((Object)new LockPacket(this.m_58899_(), uuid, isLocked));
            }
        }
    }

    @Override
    @Unique
    public void lockContainer(CompoundTag compoundTag, UUID uuid) {
        compoundTag.m_128359_("Lock", uuid.toString());
        this.f_58621_ = LockCode.m_19111_((CompoundTag)compoundTag);
    }

    @Inject(method={"canOpen"}, cancellable=true, at={@At(value="RETURN")})
    private void onCanUnlock(Player player, CallbackInfoReturnable<Boolean> cir) {
        if (!((Boolean)cir.getReturnValue()).booleanValue() && ForgeRegistries.BLOCK_ENTITY_TYPES.getKey((Object)this.m_58903_()).toString().contains("lootr")) {
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(method={"load"}, at={@At(value="TAIL")})
    private void onLoad(CompoundTag compoundTag, CallbackInfo ci) {
        if ((Double)CommonConfig.LOCK_PERCENT.get() == 0.0) {
            if (this.getPersistentData().m_128441_("LockFlag")) {
                this.getPersistentData().m_128473_("LockFlag");
            }
            this.f_58621_ = LockCode.f_19102_;
        } else {
            this.lockContainer(compoundTag);
            this.getPersistentData().m_128379_("LockFlag", true);
        }
    }
}

