/*
 * Decompiled with CFR 0.152.
 */
package com.scarasol.sona.manager;

import com.scarasol.sona.configuration.CommonConfig;
import com.scarasol.sona.entity.SoundDecoy;
import com.scarasol.sona.init.SonaEntities;
import com.scarasol.sona.network.NetworkHandler;
import com.scarasol.sona.network.SoundDecoyPacket;
import com.scarasol.sona.network.SyncSoundPacket;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistries;

public class SoundManager {
    private static final List<String> soundWhiteList = new ArrayList<String>();
    private static boolean soundOpen;

    public static boolean isSoundOpen() {
        return soundOpen;
    }

    public static void setSoundOpen(boolean soundOpen) {
        SoundManager.soundOpen = soundOpen;
    }

    public static void addSoundWhiteList(String sound) {
        soundWhiteList.add(sound);
    }

    public static void syncSoundWhiteList(ServerPlayer player) {
        for (String sound : soundWhiteList) {
            NetworkHandler.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> player), (Object)new SyncSoundPacket(sound, soundOpen));
        }
    }

    public static boolean isSoundAttractedMob(Mob mob) {
        if (CommonConfig.findIndex(ForgeRegistries.ENTITY_TYPES.getKey((Object)mob.m_6095_()).toString(), (List)CommonConfig.SOUND_ATTRACTED_MOB_WHITELIST.get()) != -1) {
            return true;
        }
        if (CommonConfig.findIndex(ForgeRegistries.ENTITY_TYPES.getKey((Object)mob.m_6095_()).toString(), (List)CommonConfig.SOUND_ATTRACTED_MOB_BLACKLIST.get()) != -1) {
            return false;
        }
        return mob.m_6336_() == MobType.f_21641_;
    }

    public static void insertAi(Mob mob) {
        if (SoundManager.isSoundAttractedMob(mob)) {
            mob.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal(mob, Mob.class, 5, false, false, livingEntity -> livingEntity instanceof SoundDecoy));
        }
    }

    public static int getIndex(String soundName) {
        int index = CommonConfig.findIndex(soundName, soundWhiteList);
        if (index == -1) {
            index = CommonConfig.containSearch(soundName, soundWhiteList);
        }
        return index;
    }

    public static int getAmplifier(int index) {
        String[] str = soundWhiteList.get(index).split(",");
        if (str.length == 2) {
            return Math.max(Integer.parseInt(str[1].trim()), 0);
        }
        return 0;
    }

    public static void spawnSoundDecoy(Level level, double x, double y, double z, int amplifier) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            SoundDecoy soundDecoy = new SoundDecoy((EntityType<? extends Mob>)((EntityType)SonaEntities.SOUND_DECOY.get()), level, amplifier);
            soundDecoy.m_6034_(x, y, z);
            soundDecoy.m_6518_((ServerLevelAccessor)serverLevel, level.m_6436_(BlockPos.m_274561_((double)x, (double)y, (double)z)), MobSpawnType.MOB_SUMMONED, null, null);
            serverLevel.m_7967_((Entity)soundDecoy);
        } else if (level.m_5776_()) {
            NetworkHandler.PACKET_HANDLER.sendToServer((Object)new SoundDecoyPacket(x, y, z, amplifier));
        }
    }
}

