/*
 * Decompiled with CFR 0.152.
 */
package com.scarasol.sona.manager;

import com.scarasol.sona.configuration.CommonConfig;
import com.scarasol.sona.item.IRustItem;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterials;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.ItemAttributeModifierEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class RustManager {
    private static final UUID MAINHAND = UUID.fromString("896D3245-0A4E-2D3B-C6F1-01FF91CBC32E");
    private static final UUID HELMET = UUID.fromString("3F118FAD-E494-B937-AC9E-7BEEEDDD1E36");
    private static final UUID CHESTPLATE = UUID.fromString("BF2875F6-0B93-3943-C365-FB58C8A26AD2");
    private static final UUID LEGGINGS = UUID.fromString("35E878C0-2E0B-34C0-DC9E-B35FBE7A85C0");
    private static final UUID BOOTS = UUID.fromString("F160DDE5-F273-FB79-BFD5-30DD470A988E");

    public static void putRust(ItemStack itemStack, double rustValue) {
        itemStack.m_41784_().m_128347_("RustValue", rustValue);
    }

    public static double getRust(ItemStack itemStack) {
        return itemStack.m_41784_().m_128459_("RustValue");
    }

    public static double getRust(Object object) {
        if (object instanceof ItemStack) {
            ItemStack itemStack = (ItemStack)object;
            return RustManager.getRust(itemStack);
        }
        return -1.0;
    }

    public static void addRust(ItemStack itemStack, double addition) {
        if (addition > 0.0) {
            addition *= (double)((Double)CommonConfig.RUST_WEIGHT.get()).floatValue();
        }
        RustManager.addActualRust(itemStack, addition);
    }

    public static void addActualRust(ItemStack itemStack, double addition) {
        double rust = addition > 0.0 ? Math.min(100.0, addition + RustManager.getRust(itemStack)) : Math.max(0.0, addition + RustManager.getRust(itemStack));
        RustManager.putRust(itemStack, rust);
    }

    public static void putWaxed(ItemStack itemStack, int times) {
        itemStack.m_41784_().m_128405_("Waxed", times);
    }

    public static int getWaxed(ItemStack itemStack) {
        return itemStack.m_41784_().m_128451_("Waxed");
    }

    public static void addWaxed(ItemStack itemStack, int addition) {
        int waxed = addition > 0 ? Math.min((Integer)CommonConfig.WAX_TIMES.get(), addition + RustManager.getWaxed(itemStack)) : Math.max(0, addition + RustManager.getWaxed(itemStack));
        RustManager.putWaxed(itemStack, waxed);
    }

    public static boolean isWaxed(ItemStack itemStack) {
        return itemStack.m_41784_().m_128451_("Waxed") > 0;
    }

    public static void rustItem(ItemStack itemStack, LivingEntity livingEntity, EquipmentSlot equipmentSlot) {
        if (!RustManager.canBeRust(itemStack)) {
            return;
        }
        double rustValue = RustManager.getRust(itemStack);
        if (rustValue >= 75.0) {
            Random random = new Random();
            if (random.nextDouble() < (rustValue - 75.0) / 800.0) {
                itemStack.m_41622_(9999999, livingEntity, consumer -> consumer.m_21166_(equipmentSlot));
            }
        }
        if (RustManager.isWaxed(itemStack)) {
            if (!((Boolean)CommonConfig.WAX_PERMANENT.get()).booleanValue()) {
                RustManager.addWaxed(itemStack, -1);
            }
            return;
        }
        rustValue = new Random().nextDouble(0.2, 0.6) + rustValue / 100.0;
        RustManager.addRust(itemStack, rustValue);
    }

    public static void rustItem(Object object, LivingEntity livingEntity, EquipmentSlot equipmentSlot) {
        if (object instanceof ItemStack) {
            ItemStack itemStack = (ItemStack)object;
            RustManager.rustItem(itemStack, livingEntity, equipmentSlot);
        }
    }

    public static void addRustAttributeModifier(ItemAttributeModifierEvent event) {
        ItemStack itemStack = event.getItemStack();
        if (!RustManager.canBeRust(itemStack)) {
            return;
        }
        double rustValue = RustManager.getRust(itemStack);
        if (rustValue < 50.0) {
            return;
        }
        if (itemStack.m_41720_() instanceof TieredItem && event.getSlotType() == EquipmentSlot.MAINHAND) {
            double value = 1.0;
            UUID equipmentSlot = MAINHAND;
            double multiplier = rustValue >= 75.0 ? -0.5 : -0.25;
            for (AttributeModifier attributeModifier : event.getModifiers().get((Object)Attributes.f_22281_)) {
                if (attributeModifier.m_22217_() != AttributeModifier.Operation.ADDITION) continue;
                value += attributeModifier.m_22218_();
            }
            event.addModifier(Attributes.f_22281_, new AttributeModifier(equipmentSlot, "Rust Modifier", multiplier * value, AttributeModifier.Operation.ADDITION));
        } else {
            Item item = itemStack.m_41720_();
            if (item instanceof ArmorItem) {
                ArmorItem armorItem = (ArmorItem)item;
                if (event.getSlotType() == armorItem.m_40402_()) {
                    double multiplier = rustValue >= 75.0 ? -0.1 : -0.05;
                    event.addModifier(Attributes.f_22283_, new AttributeModifier(switch (armorItem.m_40402_()) {
                        case EquipmentSlot.CHEST -> CHESTPLATE;
                        case EquipmentSlot.LEGS -> LEGGINGS;
                        case EquipmentSlot.FEET -> BOOTS;
                        default -> HELMET;
                    }, "Rust Modifier", multiplier, AttributeModifier.Operation.MULTIPLY_BASE));
                }
            }
        }
    }

    public static boolean canBeRust(Object obj) {
        if (obj instanceof ItemStack) {
            ItemStack itemStack = (ItemStack)obj;
            return RustManager.canBeRust(itemStack.m_41720_());
        }
        return false;
    }

    public static boolean canBeRust(ItemStack itemStack) {
        return RustManager.canBeRust(itemStack.m_41720_());
    }

    public static boolean canBeRust(Item item) {
        ArmorItem armorItem;
        TieredItem tieredItem;
        if (CommonConfig.findIndex(ForgeRegistries.ITEMS.getKey((Object)item).toString(), (List)CommonConfig.RUST_WHITELIST.get()) != -1) {
            return false;
        }
        if (item instanceof TieredItem && (tieredItem = (TieredItem)item).m_43314_() == Tiers.IRON) {
            return true;
        }
        if (item instanceof ArmorItem && ((armorItem = (ArmorItem)item).m_40401_() == ArmorMaterials.IRON || armorItem.m_40401_() == ArmorMaterials.CHAIN)) {
            return true;
        }
        return CommonConfig.findIndex(ForgeRegistries.ITEMS.getKey((Object)item).toString(), (List)CommonConfig.RUST_BLACKLIST.get()) != -1;
    }

    public static void tooltipInsert(List<Component> toolTip, ItemStack itemStack) {
        double rustValue = RustManager.getRust(itemStack);
        if (rustValue < 50.0) {
            toolTip.add(Math.min(1, toolTip.size()), (Component)Component.m_237115_((String)"tooltip.sona.rust.brand_new").m_130940_(ChatFormatting.DARK_GREEN));
        } else if (rustValue < 75.0) {
            toolTip.add(Math.min(1, toolTip.size()), (Component)Component.m_237115_((String)"tooltip.sona.rust.slightly_rusted").m_130940_(ChatFormatting.YELLOW));
            if (itemStack.m_41720_() instanceof TieredItem) {
                toolTip.add(Math.min(7, toolTip.size()), (Component)Component.m_237113_((String)("-5% " + Component.m_237115_((String)"tooltip.sona.rust.tool_rust").getString())).m_130940_(ChatFormatting.RED));
            }
        } else {
            toolTip.add(Math.min(1, toolTip.size()), (Component)Component.m_237115_((String)"tooltip.sona.rust.heavily_rusted").m_130940_(ChatFormatting.RED));
            if (itemStack.m_41720_() instanceof TieredItem) {
                toolTip.add(Math.min(7, toolTip.size()), (Component)Component.m_237113_((String)("-15% " + Component.m_237115_((String)"tooltip.sona.rust.tool_rust").getString())).m_130940_(ChatFormatting.RED));
            }
        }
        if (RustManager.isWaxed(itemStack)) {
            if (((Boolean)CommonConfig.WAX_PERMANENT.get()).booleanValue()) {
                toolTip.add(Math.min(2, toolTip.size()), (Component)Component.m_237115_((String)"tooltip.sona.rust.waxed").m_130940_(ChatFormatting.DARK_GREEN));
            } else {
                toolTip.add(Math.min(2, toolTip.size()), (Component)Component.m_237113_((String)(Component.m_237115_((String)"tooltip.sona.rust.waxed_remaining").getString() + RustManager.getWaxed(itemStack))).m_130940_(ChatFormatting.DARK_GREEN));
            }
        }
    }

    public static void onAttacked(LivingEntity livingEntity) {
        EquipmentSlot equipmentSlot = EquipmentSlot.m_20744_((EquipmentSlot.Type)EquipmentSlot.Type.ARMOR, (int)livingEntity.m_217043_().m_188503_(4));
        ItemStack itemStack = livingEntity.m_6844_(equipmentSlot);
        if (RustManager.canBeRust(itemStack)) {
            RustManager.rustItem(itemStack, livingEntity, equipmentSlot);
        }
    }

    public static boolean wax(ItemStack itemStack, ItemStack waxItem, LivingEntity livingEntity) {
        if (!RustManager.canBeRust(itemStack)) {
            return false;
        }
        int index = CommonConfig.findIndex(ForgeRegistries.ITEMS.getKey((Object)waxItem.m_41720_()).toString(), (List)CommonConfig.WAX_ITEM.get());
        if (index == -1) {
            return false;
        }
        String[] waxInfo = ((String)((List)CommonConfig.WAX_ITEM.get()).get(index)).split(",");
        if (waxInfo.length < 2) {
            return false;
        }
        int damage = Integer.parseInt(waxInfo[1].trim());
        if (RustManager.consume(waxItem, damage, livingEntity)) {
            RustManager.putWaxed(itemStack, (Integer)CommonConfig.WAX_TIMES.get());
            RustManager.rustParticle(livingEntity.m_9236_(), new Random(), livingEntity.m_20185_(), livingEntity.m_20186_(), livingEntity.m_20189_(), true);
            return true;
        }
        return false;
    }

    public static boolean removalRust(ItemStack itemStack, ItemStack removalItem, LivingEntity livingEntity) {
        if (!RustManager.canBeRust(itemStack)) {
            return false;
        }
        int index = CommonConfig.findIndex(ForgeRegistries.ITEMS.getKey((Object)removalItem.m_41720_()).toString(), (List)CommonConfig.RUST_REMOVE_ITEM.get());
        if (index == -1) {
            return false;
        }
        String[] removalInfo = ((String)((List)CommonConfig.RUST_REMOVE_ITEM.get()).get(index)).split(",");
        if (removalInfo.length < 3) {
            return false;
        }
        int damage = Integer.parseInt(removalInfo[2].trim());
        double removal = -Double.parseDouble(removalInfo[1].trim());
        if (RustManager.consume(removalItem, damage, livingEntity)) {
            RustManager.addRust(itemStack, removal);
            RustManager.rustParticle(livingEntity.m_9236_(), new Random(), livingEntity.m_20185_(), livingEntity.m_20186_(), livingEntity.m_20189_(), false);
            return true;
        }
        return false;
    }

    public static boolean consume(ItemStack itemStack, int number, LivingEntity livingEntity) {
        Player player;
        if (livingEntity instanceof Player && (player = (Player)livingEntity).m_7500_()) {
            return true;
        }
        if (itemStack.m_41763_()) {
            if (number > itemStack.m_41776_() - itemStack.m_41773_()) {
                return false;
            }
            itemStack.m_41622_(number, livingEntity, consumer -> consumer.m_21166_(EquipmentSlot.OFFHAND));
        } else {
            if (number > itemStack.m_41613_()) {
                return false;
            }
            itemStack.m_41774_(number);
        }
        return true;
    }

    public static void rustParticle(Level level, Random random, double x, double y, double z, boolean wax) {
        SoundEvent soundEvent;
        SimpleParticleType particleType;
        if (wax) {
            particleType = ParticleTypes.f_175828_;
            soundEvent = SoundEvents.f_144178_;
        } else {
            particleType = ParticleTypes.f_175831_;
            soundEvent = SoundEvents.f_144059_;
        }
        for (int i = 0; i < 10; ++i) {
            double d4 = random.nextGaussian() * 0.02;
            double d5 = random.nextGaussian() * 0.02;
            double d6 = random.nextGaussian() * 0.02;
            double d = 0.95;
            level.m_7106_((ParticleOptions)particleType, x + (double)0.13125f + (double)0.7375f * (double)random.nextFloat(), y + d + (double)random.nextFloat() * (1.0 - d), z + (double)0.13125f + (double)0.7375f * (double)random.nextFloat(), d4, d5, d6);
            level.m_6263_(null, x, y, z, soundEvent, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }

    public static void changeRustModel(ItemStack itemStack) {
        if (itemStack.m_41720_() instanceof IRustItem && RustManager.canBeRust(itemStack)) {
            if (RustManager.getRust(itemStack) > 70.0) {
                itemStack.m_41784_().m_128405_("CustomModelData", 1);
            } else {
                itemStack.m_41784_().m_128405_("CustomModelData", 0);
            }
        }
    }

    public static void changeRustModel(Object object) {
        if (object instanceof ItemStack) {
            ItemStack itemStack = (ItemStack)object;
            RustManager.changeRustModel(itemStack);
        }
    }
}

