/*
 * Decompiled with CFR 0.152.
 */
package com.scarasol.sona.manager;

import com.scarasol.sona.configuration.CommonConfig;
import com.scarasol.sona.init.SonaSounds;
import com.scarasol.sona.network.NetworkHandler;
import com.scarasol.sona.network.RotPacket;
import java.util.List;
import java.util.Random;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.PlayerEnderChestContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class RotManager {
    public static void rotWhenStack(ItemStack itemStack, double rotValue1, double rotValue2, int count1, int count2, long saveTime) {
        if (itemStack.m_41614_() && count2 > 0) {
            double rotValue = (rotValue1 * (double)count1 + rotValue2 * (double)count2) / (double)(count1 + count2);
            RotManager.putRot(itemStack, rotValue);
            RotManager.putRotSaveTime(itemStack, Math.max(Math.min(RotManager.getRotSaveTime(itemStack), saveTime), 0L));
        }
    }

    public static void putRot(ItemStack itemStack, double rotValue) {
        itemStack.m_41784_().m_128347_("RotValue", rotValue);
    }

    public static double getRot(ItemStack itemStack) {
        return itemStack.m_41784_().m_128459_("RotValue");
    }

    public static void addRot(ItemStack itemStack, double addition) {
        if (addition > 0.0) {
            addition *= (double)((Double)CommonConfig.ROT_WEIGHT.get()).floatValue();
        }
        RotManager.addActualRot(itemStack, addition);
    }

    public static void addActualRot(ItemStack itemStack, double addition) {
        double rot = addition > 0.0 ? Math.min(100.0, addition + RotManager.getRot(itemStack)) : Math.max(0.0, addition + RotManager.getRot(itemStack));
        RotManager.putRot(itemStack, rot);
    }

    public static void putMultiplier(ItemStack itemStack, double rotMultiplier) {
        itemStack.m_41784_().m_128347_("RotMultiplier", rotMultiplier);
    }

    public static double getMultiplier(ItemStack itemStack) {
        double multiplier = itemStack.m_41784_().m_128459_("RotMultiplier");
        if (multiplier == 0.0) {
            multiplier = RotManager.initMultiplier(itemStack);
            RotManager.putMultiplier(itemStack, multiplier);
        }
        if (RotManager.isWarped(itemStack)) {
            multiplier *= ((Double)CommonConfig.WARPED_WEIGHT.get()).doubleValue();
        }
        return multiplier;
    }

    public static void putRotSaveTime(ItemStack itemStack, long gameTime) {
        itemStack.m_41784_().m_128356_("RotSaveTime", gameTime);
    }

    public static long getRotSaveTime(ItemStack itemStack) {
        return itemStack.m_41784_().m_128454_("RotSaveTime");
    }

    public static void putWarp(ItemStack itemStack, boolean warped) {
        itemStack.m_41784_().m_128379_("Warped", warped);
    }

    public static boolean isWarped(ItemStack itemStack) {
        return itemStack.m_41784_().m_128471_("Warped");
    }

    public static double initMultiplier(ItemStack itemStack) {
        int index = Math.max(CommonConfig.findIndex(ForgeRegistries.ITEMS.getKey((Object)itemStack.m_41720_()).toString(), (List)CommonConfig.ROT_DETAIL.get()), CommonConfig.tagSearch(itemStack, (List)CommonConfig.ROT_DETAIL.get()));
        double rate = 1.0;
        if (index == -1) {
            ResourceLocation resourceLocation = ForgeRegistries.ITEMS.getKey((Object)itemStack.m_41720_());
            if ("zombiekit".equals(resourceLocation.m_135827_())) {
                if ("chocolate".equals(resourceLocation.m_135815_())) {
                    rate = 0.02;
                } else if ("compressed_biscuit".equals(resourceLocation.m_135815_())) {
                    rate = 0.01;
                }
            }
            return rate;
        }
        String[] str = ((String)((List)CommonConfig.ROT_DETAIL.get()).get(index)).split(",");
        if (str.length < 3) {
            return rate;
        }
        if (Double.parseDouble(str[1].trim()) <= 0.0) {
            return rate;
        }
        rate = Double.parseDouble(str[1].trim());
        return rate;
    }

    public static void eatRotFood(LivingEntity livingEntity, ItemStack itemStack) {
        double rotValue = RotManager.getRot(itemStack);
        if (rotValue >= 90.0) {
            livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19614_, 600, 0, false, false));
            livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19604_, 400, 0, false, false));
        } else if (rotValue >= 70.0 && livingEntity.m_9236_().m_213780_().m_188500_() > 0.75) {
            livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19614_, 600, 0, false, false));
            livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19604_, 400, 0, false, false));
        } else if (rotValue >= 40.0 && livingEntity.m_9236_().m_213780_().m_188500_() > 0.9) {
            livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19604_, 400, 0, false, false));
        }
    }

    public static boolean warpFood(ItemStack food, ItemStack warpItem, LivingEntity livingEntity) {
        if (!RotManager.canBeRotten(food) || !food.m_41614_()) {
            return false;
        }
        if (!((List)CommonConfig.WARPED_ITEMS.get()).contains(ForgeRegistries.ITEMS.getKey((Object)warpItem.m_41720_()).toString())) {
            return false;
        }
        int warpCount = Math.min(warpItem.m_41613_(), food.m_41613_());
        ItemStack warpedFood = food.m_41777_();
        RotManager.putWarp(warpedFood, true);
        warpedFood.m_41764_(warpCount);
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)warpedFood);
        }
        warpItem.m_41774_(warpCount);
        food.m_41774_(warpCount);
        RotManager.rotParticle(livingEntity.m_9236_(), new Random(), livingEntity.m_20185_(), livingEntity.m_20186_(), livingEntity.m_20189_());
        return true;
    }

    public static void rotParticle(Level level, Random random, double x, double y, double z) {
        SimpleParticleType particleType = ParticleTypes.f_123749_;
        SoundEvent soundEvent = (SoundEvent)SonaSounds.SLIDER_ZIPPER_BAG.get();
        for (int i = 0; i < 10; ++i) {
            double d4 = random.nextGaussian() * 0.02;
            double d5 = random.nextGaussian() * 0.02;
            double d6 = random.nextGaussian() * 0.02;
            double d = 0.95;
            level.m_7106_((ParticleOptions)particleType, x + (double)0.13125f + (double)0.7375f * (double)random.nextFloat(), y + d + (double)random.nextFloat() * (1.0 - d), z + (double)0.13125f + (double)0.7375f * (double)random.nextFloat(), d4, d5, d6);
            level.m_6263_(null, x, y, z, soundEvent, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }

    public static double getContainerMultiplier(Level level, @Nullable BlockPos blockPos) {
        String[] str;
        int index = -1;
        if (blockPos == null) {
            index = CommonConfig.findIndex("minecraft:ender_chest", (List)CommonConfig.ROT_CONTAINER.get());
        } else {
            BlockEntity blockEntity = level.m_7702_(blockPos);
            if (blockEntity != null) {
                index = CommonConfig.findIndex(ForgeRegistries.BLOCK_ENTITY_TYPES.getKey((Object)blockEntity.m_58903_()).toString(), (List)CommonConfig.ROT_CONTAINER.get());
            }
            if (index == -1) {
                index = CommonConfig.findIndex(ForgeRegistries.BLOCKS.getKey((Object)level.m_8055_(blockPos).m_60734_()).toString(), (List)CommonConfig.ROT_CONTAINER.get());
            }
        }
        if (index != -1 && (str = ((String)((List)CommonConfig.ROT_CONTAINER.get()).get(index)).split(",")).length >= 2) {
            return Double.parseDouble(str[1].trim());
        }
        return 1.0;
    }

    public static void syncRotValue(double rotValue, int slot, boolean flag, ServerPlayer player) {
        NetworkHandler.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> player), (Object)new RotPacket(rotValue, slot, flag));
    }

    public static void containerOpen(Player player, Container container, AbstractContainerMenu abstractContainerMenu) {
        double containerMultiplier = 1.0;
        double temperature = 1.0;
        if (container instanceof BlockEntity) {
            BlockEntity blockEntity = (BlockEntity)container;
            double height = blockEntity.m_58899_().m_123342_();
            containerMultiplier = RotManager.getContainerMultiplier(player.m_9236_(), blockEntity.m_58899_());
            if (((Boolean)CommonConfig.ROT_TEMPERATURE.get()).booleanValue() && CommonConfig.findIndex(ForgeRegistries.BLOCK_ENTITY_TYPES.getKey((Object)blockEntity.m_58903_()).toString(), (List)CommonConfig.ROT_TEMPERATURE_WHITELIST.get()) == -1) {
                if (height < 0.0) {
                    temperature = 0.5;
                } else if (height < 30.0) {
                    temperature = 0.7;
                } else if (height < 60.0) {
                    temperature = 0.9;
                }
                temperature *= (double)(((Biome)player.m_9236_().m_204166_(blockEntity.m_58899_()).m_203334_()).m_47554_() / 2.0f) + 0.6;
            }
        } else if (container instanceof PlayerEnderChestContainer) {
            containerMultiplier = RotManager.getContainerMultiplier(player.m_9236_(), null);
        }
        if (containerMultiplier != 0.0 && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            RotManager.rotInContainer(serverPlayer, (List<Slot>)abstractContainerMenu.f_38839_, abstractContainerMenu.f_38839_.size() - serverPlayer.m_150109_().f_35974_.size(), containerMultiplier, serverPlayer.m_9236_().m_46467_(), temperature);
        }
    }

    public static void rotInContainer(ServerPlayer serverPlayer, List<Slot> slots, int size, double containerMultiplier, long gameTime, double temperature) {
        for (int i = 0; i < size; ++i) {
            long saveTime;
            Slot slot = slots.get(i);
            ItemStack itemStack = slot.m_7993_().m_41777_();
            if (!itemStack.m_41614_() || !RotManager.canBeRotten(itemStack) || (saveTime = RotManager.getRotSaveTime(itemStack)) == 0L) continue;
            double rotValue = RotManager.getRot(itemStack);
            int cycle = 1680;
            cycle = Math.max((int)((double)cycle / temperature / RotManager.getMultiplier(itemStack) / containerMultiplier), 1);
            double rotAddition = (gameTime - saveTime) / (long)cycle;
            if (rotValue + (rotAddition *= ((Double)CommonConfig.ROT_WEIGHT.get()).doubleValue()) >= 100.0) {
                RotManager.rotten(itemStack, null, slot);
                continue;
            }
            RotManager.addActualRot(itemStack, rotAddition);
            slot.m_5852_(itemStack);
            RotManager.syncRotValue(RotManager.getRot(itemStack), i, false, serverPlayer);
            slot.m_6654_();
        }
    }

    public static void rotTimeUpdate(List<Slot> slots, int size, long gameTime) {
        for (int i = 0; i < size; ++i) {
            Slot slot = slots.get(i);
            ItemStack itemStack = slot.m_7993_();
            if (!itemStack.m_41614_() || !RotManager.canBeRotten(itemStack)) continue;
            RotManager.putRotSaveTime(itemStack, gameTime);
            slot.m_5852_(itemStack);
            slot.m_6654_();
        }
    }

    public static void rotten(ItemStack itemStack, SlotAccess slotAccess, Slot slot) {
        int index = Math.max(CommonConfig.findIndex(ForgeRegistries.ITEMS.getKey((Object)itemStack.m_41720_()).toString(), (List)CommonConfig.ROT_DETAIL.get()), CommonConfig.tagSearch(itemStack, (List)CommonConfig.ROT_DETAIL.get()));
        if (index == -1) {
            int amount = itemStack.m_41613_();
            itemStack.m_41764_(0);
            Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation((String)CommonConfig.ROT_RESULT.get()));
            if (item != null) {
                ItemStack output = new ItemStack((ItemLike)item);
                output.m_41764_(amount);
                if (slot == null && slotAccess != null) {
                    slotAccess.m_142104_(output);
                } else if (slot != null && slotAccess == null) {
                    slot.m_5852_(output);
                    slot.m_6654_();
                }
            }
            return;
        }
        String[] str = ((String)((List)CommonConfig.ROT_DETAIL.get()).get(index)).split(",");
        if (str.length < 3) {
            int amount = itemStack.m_41613_();
            itemStack.m_41764_(0);
            Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation((String)CommonConfig.ROT_RESULT.get()));
            if (item != null) {
                ItemStack output = new ItemStack((ItemLike)item);
                output.m_41764_(amount);
                if (slot == null && slotAccess != null) {
                    slotAccess.m_142104_(output);
                } else if (slot != null && slotAccess == null) {
                    slot.m_5852_(output);
                    slot.m_6654_();
                }
            }
            return;
        }
        int count = itemStack.m_41613_();
        itemStack.m_41764_(0);
        Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(str[2].trim()));
        if (item == null) {
            item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation((String)CommonConfig.ROT_RESULT.get()));
        }
        if (item != null) {
            ItemStack itemStackNew = new ItemStack((ItemLike)item);
            itemStackNew.m_41764_(count);
            if (slot == null && slotAccess != null) {
                slotAccess.m_142104_(itemStackNew);
            } else if (slot != null && slotAccess == null) {
                slot.m_5852_(itemStackNew);
                slot.m_6654_();
            }
        }
    }

    public static boolean canBeRotten(ItemStack itemStack) {
        ResourceLocation resourceLocation = ForgeRegistries.ITEMS.getKey((Object)itemStack.m_41720_());
        if ("zombiekit".equals(resourceLocation.m_135827_()) && resourceLocation.m_135815_().contains("canned")) {
            return false;
        }
        return !((List)CommonConfig.ROT_WHITELIST.get()).contains(ForgeRegistries.ITEMS.getKey((Object)itemStack.m_41720_()).toString());
    }

    public static void rotTick(Object object, Entity entity, int slot, double temperature) {
        ItemStack itemStack;
        if (object instanceof ItemStack && (itemStack = (ItemStack)object).m_41614_() && RotManager.canBeRotten(itemStack)) {
            int cycle = 1680;
            cycle = (Boolean)CommonConfig.ROT_TEMPERATURE.get() != false ? Math.max((int)((double)cycle / temperature / RotManager.getMultiplier(itemStack)), 1) : Math.max((int)((double)cycle / RotManager.getMultiplier(itemStack)), 1);
            if (entity.m_9236_().m_46467_() % (long)cycle == 0L) {
                RotManager.addRot(itemStack, 1.0);
                if (entity instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)entity;
                    RotManager.syncRotValue(RotManager.getRot(itemStack), slot, true, serverPlayer);
                }
            }
            if (RotManager.getRot(itemStack) >= 100.0) {
                RotManager.rotten(itemStack, entity.m_141942_(slot), null);
            }
        }
    }

    public static void tooltipInsert(List<Component> toolTip, ItemStack itemStack) {
        double rotValue = RotManager.getRot(itemStack);
        if (rotValue < 40.0) {
            toolTip.add(Math.min(1, toolTip.size()), (Component)Component.m_237115_((String)"tooltip.sona.rot.fresh").m_130940_(ChatFormatting.DARK_GREEN));
        } else if (rotValue < 70.0) {
            toolTip.add(Math.min(1, toolTip.size()), (Component)Component.m_237115_((String)"tooltip.sona.rot.slightly_spoiled").m_130940_(ChatFormatting.DARK_AQUA));
        } else if (rotValue < 90.0) {
            toolTip.add(Math.min(1, toolTip.size()), (Component)Component.m_237115_((String)"tooltip.sona.rot.spoiled").m_130940_(ChatFormatting.YELLOW));
        } else {
            toolTip.add(Math.min(1, toolTip.size()), (Component)Component.m_237115_((String)"tooltip.sona.rot.heavily_spoiled").m_130940_(ChatFormatting.RED));
        }
        if (RotManager.isWarped(itemStack)) {
            toolTip.add(Math.min(2, toolTip.size()), (Component)Component.m_237115_((String)"tooltip.sona.rot.warped").m_130940_(ChatFormatting.ITALIC).m_130940_(ChatFormatting.DARK_GREEN));
        }
    }
}

