/*
 * Decompiled with CFR 0.152.
 */
package com.scarasol.sona.manager;

import com.scarasol.sona.accessor.ILivingEntityAccessor;
import com.scarasol.sona.configuration.CommonConfig;
import com.scarasol.sona.init.SonaDamageTypes;
import com.scarasol.sona.init.SonaMobEffects;
import java.util.List;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;

public class InjuryManager {
    public static float getInjury(ILivingEntityAccessor livingEntity) {
        return livingEntity.getInjuryLevel();
    }

    public static void setInjury(ILivingEntityAccessor livingEntity, float injury) {
        livingEntity.setInjuryLevel(injury);
        livingEntity.setBandageLevel(Math.min(InjuryManager.getBandage(livingEntity), 100.0f - injury));
    }

    public static void addInjury(ILivingEntityAccessor livingEntity, float addition) {
        if (addition < 0.0f) {
            addition *= ((Double)CommonConfig.INJURY_WEIGHT.get()).floatValue();
        }
        InjuryManager.addActualInjury(livingEntity, addition);
    }

    public static void addActualInjury(ILivingEntityAccessor livingEntity, float addition) {
        float injury = InjuryManager.getInjury(livingEntity) + addition;
        if (addition > 0.0f) {
            livingEntity.setInjuryLevel(Math.min(100.0f, injury));
            livingEntity.setBandageLevel(Math.min(InjuryManager.getBandage(livingEntity), 100.0f - injury));
        } else {
            livingEntity.setInjuryLevel(Math.max(0.0f, injury));
        }
    }

    public static float getBandage(ILivingEntityAccessor livingEntity) {
        return livingEntity.getBandageLevel();
    }

    private static void setBandage(ILivingEntityAccessor livingEntity, float bandage) {
        livingEntity.setBandageLevel(bandage);
    }

    public static void setBandageSafe(ILivingEntityAccessor livingEntity, float bandage) {
        bandage = Math.max(0.0f, Math.min(Math.min(bandage, 50.0f), 100.0f - InjuryManager.getInjury(livingEntity)));
        InjuryManager.setBandage(livingEntity, bandage);
    }

    public static void addBandage(ILivingEntityAccessor livingEntity, float addition) {
        if (addition < 0.0f) {
            addition *= ((Double)CommonConfig.INJURY_WEIGHT.get()).floatValue();
        }
        InjuryManager.addActualBandage(livingEntity, addition);
    }

    public static void addActualBandage(ILivingEntityAccessor livingEntity, float addition) {
        float injury = InjuryManager.getInjury(livingEntity);
        float bandage = InjuryManager.getBandage(livingEntity);
        bandage = addition > 0.0f ? (injury > 50.0f ? Math.min(100.0f - injury, bandage + addition) : Math.min(50.0f, bandage + addition)) : Math.max(0.0f, bandage + addition);
        InjuryManager.setBandage(livingEntity, bandage);
    }

    public static void init(ILivingEntityAccessor newPlayer, ILivingEntityAccessor oldPlayer) {
        InjuryManager.setInjury(newPlayer, Math.max(((Double)CommonConfig.INJURY_INITIAL_VALUE.get()).floatValue(), oldPlayer.getInjuryLevel()));
        InjuryManager.setBandage(newPlayer, 0.0f);
    }

    public static void injuryTick(LivingEntity livingEntity) {
        if (livingEntity.m_9236_().m_5776_()) {
            return;
        }
        Level level = livingEntity.m_9236_();
        if (livingEntity instanceof ILivingEntityAccessor) {
            ILivingEntityAccessor livingEntityAccessor = (ILivingEntityAccessor)livingEntity;
            float injury = InjuryManager.getInjury(livingEntityAccessor);
            float bandage = InjuryManager.getBandage(livingEntityAccessor);
            if (level.m_46467_() % 600L == 0L && bandage > 0.0f) {
                if (bandage >= 5.0f) {
                    InjuryManager.addBandage(livingEntityAccessor, -5.0f);
                    InjuryManager.addInjury(livingEntityAccessor, 5.0f);
                } else {
                    float recovery = InjuryManager.getBandage(livingEntityAccessor);
                    InjuryManager.setBandage(livingEntityAccessor, 0.0f);
                    InjuryManager.addInjury(livingEntityAccessor, recovery);
                }
            }
            bandage = InjuryManager.getBandage(livingEntityAccessor);
            switch (level.m_46791_()) {
                case PEACEFUL: {
                    if (level.m_46467_() % 600L != 0L) break;
                    InjuryManager.addInjury(livingEntityAccessor, 5.0f);
                    break;
                }
                case EASY: {
                    if (level.m_46467_() % 1200L != 0L || !(injury > 40.0f)) break;
                    InjuryManager.addInjury(livingEntityAccessor, 5.0f);
                    break;
                }
                case NORMAL: {
                    if (level.m_46467_() % 600L != 0L) break;
                    if (injury < 40.0f && bandage <= 0.0f) {
                        InjuryManager.addInjury(livingEntityAccessor, -2.0f);
                        break;
                    }
                    if (!(injury > 60.0f) || level.m_46467_() % 1200L != 0L) break;
                    InjuryManager.addInjury(livingEntityAccessor, 5.0f);
                    break;
                }
                case HARD: {
                    if (level.m_46467_() % 200L != 0L) break;
                    if (injury < 20.0f && bandage <= 0.0f) {
                        InjuryManager.addInjury(livingEntityAccessor, -1.0f);
                        break;
                    }
                    if (injury < 60.0f && bandage <= 0.0f && level.m_46467_() % 600L == 0L) {
                        InjuryManager.addInjury(livingEntityAccessor, -2.0f);
                        break;
                    }
                    if (!(injury > 60.0f) || level.m_46467_() % 1200L != 0L) break;
                    InjuryManager.addInjury(livingEntityAccessor, 5.0f);
                }
            }
            InjuryManager.injuryEffect(livingEntity);
        }
    }

    private static void injuryEffect(LivingEntity livingEntity) {
        if (livingEntity instanceof ILivingEntityAccessor) {
            ILivingEntityAccessor livingEntityAccessor = (ILivingEntityAccessor)livingEntity;
            float injury = InjuryManager.getInjury(livingEntityAccessor);
            float bandage = InjuryManager.getBandage(livingEntityAccessor);
            if (injury <= 0.0f) {
                livingEntity.m_6469_(SonaDamageTypes.damageSource(livingEntity.m_9236_().m_9598_(), SonaDamageTypes.INJURY), 999999.0f);
            } else if (injury < 20.0f) {
                livingEntity.m_7292_(new MobEffectInstance((MobEffect)SonaMobEffects.FRAGILITY.get(), 20, 5, false, false));
                livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 20, 1, false, false));
                livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 20, 1, false, false));
                if (bandage <= 0.0f) {
                    livingEntity.m_7292_(new MobEffectInstance((MobEffect)SonaMobEffects.EXPOSURE.get(), 20, 3, false, false));
                }
            } else if (injury < 40.0f) {
                livingEntity.m_7292_(new MobEffectInstance((MobEffect)SonaMobEffects.FRAGILITY.get(), 20, 3, false, false));
                livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 20, 0, false, false));
                livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 20, 1, false, false));
                if (bandage <= 0.0f) {
                    livingEntity.m_7292_(new MobEffectInstance((MobEffect)SonaMobEffects.EXPOSURE.get(), 20, 1, false, false));
                }
            } else if (injury < 60.0f) {
                livingEntity.m_7292_(new MobEffectInstance((MobEffect)SonaMobEffects.FRAGILITY.get(), 20, 1, false, false));
                livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 20, 0, false, false));
                livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 20, 0, false, false));
                if (bandage <= 0.0f) {
                    livingEntity.m_7292_(new MobEffectInstance((MobEffect)SonaMobEffects.EXPOSURE.get(), 20, 0, false, false));
                }
            } else if (injury < 80.0f) {
                livingEntity.m_7292_(new MobEffectInstance((MobEffect)SonaMobEffects.FRAGILITY.get(), 20, 0, false, false));
            }
        }
    }

    public static void onUseItem(ILivingEntityAccessor livingEntityAccessor, ItemStack itemStack) {
        int index = CommonConfig.findIndex(ForgeRegistries.ITEMS.getKey((Object)itemStack.m_41720_()).toString(), (List)CommonConfig.INJURY_TREATMENT_ITEM.get());
        if (index == -1) {
            return;
        }
        String[] str = ((String)((List)CommonConfig.INJURY_TREATMENT_ITEM.get()).get(index)).split(",");
        if (str.length < 3) {
            return;
        }
        InjuryManager.addInjury(livingEntityAccessor, Float.parseFloat(str[1].trim()));
        InjuryManager.addBandage(livingEntityAccessor, Float.parseFloat(str[2].trim()));
    }

    public static void onAttacked(LivingEntity target, DamageSource damageSource, double amount) {
        if (target.m_9236_().m_5776_() || amount < 1.0) {
            return;
        }
        int index = CommonConfig.findIndex(damageSource.m_19385_(), (List)CommonConfig.INJURY_EXCEPT_DAMAGESOURCE.get());
        if (index != -1) {
            return;
        }
        double maxHealth = target.m_21051_(Attributes.f_22276_).m_22135_();
        if (target instanceof ILivingEntityAccessor) {
            ILivingEntityAccessor livingEntityAccessor = (ILivingEntityAccessor)target;
            InjuryManager.injuryCalculate(livingEntityAccessor, amount / maxHealth);
        }
    }

    protected static void injuryCalculate(ILivingEntityAccessor livingEntityAccessor, double rate) {
        float blockByBandage;
        float injuryLevel = (float)(50.0 / (Math.pow(Math.E, -10.0 * rate + 4.5) + 1.0));
        if (2.0f * injuryLevel <= (blockByBandage = InjuryManager.getBandage(livingEntityAccessor))) {
            InjuryManager.addBandage(livingEntityAccessor, -2.0f * injuryLevel);
        } else {
            InjuryManager.setBandage(livingEntityAccessor, 0.0f);
            InjuryManager.addInjury(livingEntityAccessor, -1.0f * (injuryLevel - 0.5f * blockByBandage));
        }
    }

    public static void healBySleep(ILivingEntityAccessor livingEntityAccessor) {
        if (((Boolean)CommonConfig.HEAL_NEED_BANDAGE.get()).booleanValue()) {
            if (((Boolean)CommonConfig.HEAL_NEED_BANDAGE.get()).booleanValue() && InjuryManager.getInjury(livingEntityAccessor) < (float)((Integer)CommonConfig.HEAL_THRESHOLD.get()).intValue() && InjuryManager.getBandage(livingEntityAccessor) == 0.0f) {
                return;
            }
            InjuryManager.addInjury(livingEntityAccessor, ((Integer)CommonConfig.HEAL_AMOUNT.get()).intValue());
        }
    }
}

