/*
 * Decompiled with CFR 0.152.
 */
package com.scarasol.sona.manager;

import com.scarasol.sona.accessor.ILivingEntityAccessor;
import com.scarasol.sona.configuration.CommonConfig;
import com.scarasol.sona.init.SonaDamageTypes;
import com.scarasol.sona.init.SonaMobEffects;
import java.util.List;
import java.util.Random;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;

public class InfectionManager {
    public static float getInfection(ILivingEntityAccessor livingEntity) {
        return livingEntity.getInfectionLevel();
    }

    public static void setInfection(ILivingEntityAccessor livingEntity, float infection) {
        livingEntity.setInfectionLevel(infection);
    }

    public static void addInfection(ILivingEntityAccessor livingEntity, float addition) {
        if (addition > 0.0f) {
            addition *= ((Double)CommonConfig.INFECTION_WEIGHT.get()).floatValue();
        }
        InfectionManager.addActualInfection(livingEntity, addition);
    }

    public static void addActualInfection(ILivingEntityAccessor livingEntity, float addition) {
        float infection = addition > 0.0f ? Math.min(100.0f, addition + InfectionManager.getInfection(livingEntity)) : Math.max(0.0f, addition + InfectionManager.getInfection(livingEntity));
        InfectionManager.setInfection(livingEntity, infection);
    }

    public static void init(ILivingEntityAccessor newPlayer, ILivingEntityAccessor oldPlayer) {
        newPlayer.setInfectionLevel(Math.min(oldPlayer.getInfectionLevel(), ((Double)CommonConfig.INFECTION_INITIAL_VALUE.get()).floatValue()));
    }

    public static boolean canBeInfected(LivingEntity entity) {
        Player player;
        return entity instanceof Player && !(player = (Player)entity).m_7500_() && !player.m_5833_() || ((List)CommonConfig.SUSCEPTIBLE_POPULATION.get()).contains(ForgeRegistries.ENTITY_TYPES.getKey((Object)entity.m_6095_()).toString());
    }

    public static double canInfect(Entity entity) {
        List entityList = entity instanceof LivingEntity ? (List)CommonConfig.INFECTION_SOURCE_MOB.get() : (List)CommonConfig.INFECTION_SOURCE_PROJECTILE.get();
        int index = CommonConfig.findIndex(ForgeRegistries.ENTITY_TYPES.getKey((Object)entity.m_6095_()).toString(), entityList);
        if (index == -1) {
            Mob mob;
            if (entity instanceof Mob && (mob = (Mob)entity).m_6336_() == MobType.f_21641_) {
                return 1.0;
            }
            return index;
        }
        String[] info = ((String)entityList.get(index)).split(",");
        if (info.length < 2) {
            return 1.0;
        }
        return Double.parseDouble(info[1].trim());
    }

    public static void infectionTick(LivingEntity livingEntity) {
        Level level = livingEntity.m_9236_();
        if (level.m_46467_() % 1600L == 0L && livingEntity instanceof ILivingEntityAccessor) {
            ILivingEntityAccessor livingEntityAccessor = (ILivingEntityAccessor)livingEntity;
            switch (level.m_46791_()) {
                case PEACEFUL: {
                    InfectionManager.addInfection(livingEntityAccessor, -5.0f);
                    break;
                }
                case EASY: {
                    if (!(livingEntityAccessor.getInfectionLevel() < 40.0f)) break;
                    InfectionManager.addInfection(livingEntityAccessor, -2.5f);
                    break;
                }
                case NORMAL: {
                    if (livingEntityAccessor.getInfectionLevel() < 40.0f) {
                        InfectionManager.addInfection(livingEntityAccessor, -2.5f);
                    }
                    if (!(livingEntityAccessor.getInfectionLevel() > 70.0f) || livingEntity.m_21023_((MobEffect)SonaMobEffects.IMMUNITY.get())) break;
                    InfectionManager.addInfection(livingEntityAccessor, 1.0f);
                    break;
                }
                case HARD: {
                    if (!(livingEntityAccessor.getInfectionLevel() > 40.0f) || livingEntity.m_21023_((MobEffect)SonaMobEffects.IMMUNITY.get())) break;
                    InfectionManager.addInfection(livingEntityAccessor, 1.0f);
                }
            }
        }
        InfectionManager.infectionEffect(livingEntity);
    }

    protected static void infectionEffect(LivingEntity livingEntity) {
        if (livingEntity.m_9236_().m_5776_()) {
            return;
        }
        if (livingEntity instanceof ILivingEntityAccessor) {
            ILivingEntityAccessor livingEntityAccessor = (ILivingEntityAccessor)livingEntity;
            if (livingEntityAccessor.getInfectionLevel() >= 100.0f) {
                livingEntity.m_6469_(SonaDamageTypes.damageSource(livingEntity.m_9236_().m_9598_(), SonaDamageTypes.INFECTION), 999999.0f);
                if (!livingEntity.m_6084_() && !(livingEntity instanceof Player)) {
                    livingEntityAccessor.setInfectionLevel(0.0f);
                }
            } else if (livingEntityAccessor.getInfectionLevel() > 90.0f) {
                livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 20, 1, false, false));
                livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 20, 0, false, false));
                livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19612_, 20, 0, false, false));
                livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 60, 0, false, false));
            } else if (livingEntityAccessor.getInfectionLevel() > 70.0f) {
                livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 20, 0, false, false));
                livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 20, 0, false, false));
                livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19612_, 20, 0, false, false));
            } else if (livingEntityAccessor.getInfectionLevel() > 40.0f) {
                livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19612_, 20, 0, false, false));
            }
            if (livingEntityAccessor.getInfectionLevel() > 70.0f && livingEntity.m_9236_().m_46467_() % 400L == 0L && livingEntity.m_217043_().m_188500_() < 0.3) {
                livingEntity.m_9236_().m_6269_(null, (Entity)livingEntity, (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("minecraft:entity.zombie.ambient")), SoundSource.NEUTRAL, 1.0f, 1.0f);
            }
        }
    }

    public static void turnZombie(LivingEntity livingEntity) {
        EntityType entityType;
        double weightSum = InfectionManager.getWeightSum();
        double currentWeight = 0.0;
        double random = new Random().nextDouble();
        String zombieToSpawn = "";
        if (weightSum == 0.0) {
            return;
        }
        for (String str : (List)CommonConfig.ZOMBIE_LIST.get()) {
            String[] buffer = str.split(",");
            if (buffer.length < 2 || !(random < (currentWeight += Double.parseDouble(buffer[1].trim())) / weightSum)) continue;
            zombieToSpawn = buffer[0];
            break;
        }
        if ((entityType = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(new ResourceLocation(zombieToSpawn))) == null) {
            return;
        }
        Entity entityToSpawn = entityType.m_20615_(livingEntity.m_9236_());
        if (entityToSpawn == null) {
            return;
        }
        entityToSpawn.m_6034_(livingEntity.m_20185_(), livingEntity.m_20186_(), livingEntity.m_20189_());
        livingEntity.m_9236_().m_7967_(entityToSpawn);
    }

    protected static double getWeightSum() {
        double sum = 0.0;
        for (String str : (List)CommonConfig.ZOMBIE_LIST.get()) {
            String[] buffer = str.split(",");
            if (buffer.length < 2) continue;
            sum += Double.parseDouble(buffer[1].trim());
        }
        return sum;
    }

    public static void onAttacked(LivingEntity target, Entity entity) {
        if (target.m_9236_().m_5776_()) {
            return;
        }
        double weight = InfectionManager.canInfect(entity);
        if (weight != -1.0) {
            if (target.m_21023_((MobEffect)SonaMobEffects.IMMUNITY.get()) && entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                InfectionManager.immunityEffect(livingEntity, target.m_21124_((MobEffect)SonaMobEffects.IMMUNITY.get()).m_19564_());
            } else {
                if (!InfectionManager.canBeInfected(target)) {
                    return;
                }
                InfectionManager.infectionCalculate(target, weight);
            }
        }
    }

    protected static void infectionCalculate(LivingEntity livingEntity, double weight) {
        double resistanceChance;
        AttributeInstance attribute = livingEntity.m_21051_(Attributes.f_22285_);
        double d = resistanceChance = attribute != null ? 0.03 * attribute.m_22135_() : 0.0;
        if (Math.random() >= resistanceChance && livingEntity instanceof ILivingEntityAccessor) {
            ILivingEntityAccessor livingEntityAccessor = (ILivingEntityAccessor)livingEntity;
            InfectionManager.addInfection(livingEntityAccessor, (float)(weight * (200.0 / (Math.pow(livingEntity.m_21230_(), 2.0) + 50.0) + 1.0)));
        }
    }

    protected static void immunityEffect(LivingEntity livingEntity, int amplifier) {
        if (amplifier == 1) {
            livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 140, 1));
            livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 140, 1));
            livingEntity.m_7292_(new MobEffectInstance((MobEffect)SonaMobEffects.FRAGILITY.get(), 140, 1));
        } else if (amplifier == 2) {
            livingEntity.m_7292_(new MobEffectInstance((MobEffect)SonaMobEffects.FRAGILITY.get(), 140, 3));
            livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19615_, 140, 2));
            livingEntity.m_7292_(new MobEffectInstance((MobEffect)SonaMobEffects.CONFUSION.get(), 140, 0));
        }
    }

    public static void onUseItem(ILivingEntityAccessor livingEntity, ItemStack itemStack) {
        int index = Math.max(CommonConfig.tagSearch(itemStack, (List)CommonConfig.INFECTION_SOURCE_ITEM.get()), CommonConfig.findIndex(ForgeRegistries.ITEMS.getKey((Object)itemStack.m_41720_()).toString(), (List)CommonConfig.INFECTION_SOURCE_ITEM.get()));
        if (index == -1) {
            return;
        }
        String[] str = ((String)((List)CommonConfig.INFECTION_SOURCE_ITEM.get()).get(index)).split(",");
        if (str.length < 4) {
            return;
        }
        Random random = new Random();
        if (random.nextFloat() < Float.parseFloat(str[1].trim()) / 100.0f) {
            float max;
            float min = Math.min(Float.parseFloat(str[2].trim()), Float.parseFloat(str[3].trim()));
            if (min == (max = Math.max(Float.parseFloat(str[2].trim()), Float.parseFloat(str[3].trim())))) {
                InfectionManager.addInfection(livingEntity, min);
            } else {
                InfectionManager.addInfection(livingEntity, random.nextFloat(min, max));
            }
        }
    }

    public static boolean blurMessage(float infectionLevel, MutableComponent component) {
        if (infectionLevel > 70.0f) {
            component.m_130940_(ChatFormatting.OBFUSCATED);
            return true;
        }
        return false;
    }
}

