/*
 * Decompiled with CFR 0.152.
 */
package com.scarasol.sona.manager;

import com.scarasol.sona.accessor.ILivingEntityAccessor;
import com.scarasol.sona.configuration.CommonConfig;
import com.scarasol.sona.network.NetworkHandler;
import com.scarasol.sona.network.SyncChatPacket;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.OutgoingChatMessage;
import net.minecraft.network.chat.PlayerChatMessage;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistries;

public class ChatManager {
    private static boolean CHAT_LIMIT;
    private static int CHAT_RANGE;
    private static final List<String> RANGE_ITEM;

    public static boolean isChatLimit() {
        return CHAT_LIMIT;
    }

    public static void setChatLimit(boolean chatLimit) {
        CHAT_LIMIT = chatLimit;
    }

    public static int getChatRange() {
        return CHAT_RANGE;
    }

    public static void setChatRange(int chatRange) {
        CHAT_RANGE = chatRange;
    }

    public static List<String> getRangeItem() {
        return RANGE_ITEM;
    }

    public static void addRangeItem(String rangeItem) {
        RANGE_ITEM.add(rangeItem);
    }

    public static void syncChatManager(ServerPlayer serverPlayer) {
        for (String rangeItem : ChatManager.getRangeItem()) {
            NetworkHandler.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new SyncChatPacket(rangeItem, ChatManager.getChatRange(), ChatManager.isChatLimit()));
        }
    }

    public static void broadcastMessage(Player player, PlayerChatMessage playerChatMessage1) {
        Level level = player.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (player instanceof ILivingEntityAccessor) {
                ILivingEntityAccessor livingEntityAccessor = (ILivingEntityAccessor)player;
                int range = ChatManager.getMaxRange(player);
                BlockPos pos = player.m_20183_();
                Object message = playerChatMessage1.m_245692_().getString();
                message = (String)message + " @TheMessageCutter@ " + livingEntityAccessor.getInfectionLevel() + " ; " + pos.m_123341_() + ", " + pos.m_123342_() + ", " + pos.m_123343_() + " ; " + range;
                ChatType.Bound bound = ChatType.m_240980_((ResourceKey)ChatType.f_130598_, (Entity)player);
                serverLevel.m_7654_().m_241158_(playerChatMessage1.m_245692_(), bound, null);
                PlayerChatMessage playerChatMessage = playerChatMessage1.m_241956_((Component)Component.m_237113_((String)message));
                OutgoingChatMessage outgoingChatMessage = OutgoingChatMessage.m_247282_((PlayerChatMessage)playerChatMessage);
                if (range == -2 || !ChatManager.isChatLimit()) {
                    ChatManager.broadcastMessageInServer(serverLevel, outgoingChatMessage, bound);
                } else if (range == -1) {
                    ChatManager.broadcastMessageInLevel(serverLevel, outgoingChatMessage, bound);
                } else {
                    ChatManager.broadcastMessageInRange(serverLevel, outgoingChatMessage, bound, (int)((double)range * 1.5), new Vec3((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()));
                }
            }
        }
    }

    public static void broadcastMessageInRange(ServerLevel serverLevel, OutgoingChatMessage outgoingChatMessage, ChatType.Bound bound, int range, Vec3 center) {
        serverLevel.m_6443_(ServerPlayer.class, new AABB(center, center).m_82400_((double)range), e -> true).forEach(p -> p.m_245069_(outgoingChatMessage, false, bound));
    }

    public static void broadcastMessageInLevel(ServerLevel serverLevel, OutgoingChatMessage outgoingChatMessage, ChatType.Bound bound) {
        serverLevel.m_8795_(serverPlayer -> true).forEach(p -> p.m_245069_(outgoingChatMessage, false, bound));
    }

    public static void broadcastMessageInServer(ServerLevel serverLevel, OutgoingChatMessage outgoingChatMessage, ChatType.Bound bound) {
        serverLevel.m_7654_().m_6846_().m_11314_().forEach(p -> p.m_245069_(outgoingChatMessage, false, bound));
    }

    public static int getMaxRange(Player player) {
        Inventory inventory = player.m_150109_();
        int maxRange = ChatManager.getChatRange();
        for (int i = 0; i <= 40; ++i) {
            ItemStack item = inventory.m_8020_(i);
            int range = ChatManager.getItemRange(item);
            if (range > 0 && maxRange >= 0) {
                maxRange = Math.max(maxRange, range);
                continue;
            }
            if (range == -1 && maxRange != -2) {
                maxRange = -1;
                continue;
            }
            if (range != -2) continue;
            maxRange = -2;
        }
        return maxRange;
    }

    public static boolean canReceiveBeyondMessage(Player player) {
        Inventory inventory = player.m_150109_();
        for (int i = 0; i <= 40; ++i) {
            ItemStack item = inventory.m_8020_(i);
            if (ChatManager.getItemRange(item) == -3) continue;
            return true;
        }
        return false;
    }

    public static int getItemRange(ItemStack itemStack) {
        if (!itemStack.m_41782_()) {
            return -3;
        }
        CompoundTag tag = itemStack.m_41784_();
        if (tag.m_128441_("MessageRange")) {
            return tag.m_128451_("MessageRange");
        }
        return -3;
    }

    public static void setItemRange(Object object) {
        if (object instanceof ItemStack) {
            ItemStack itemStack = (ItemStack)object;
            ChatManager.setItemRange(itemStack);
        }
    }

    public static void setItemRange(ItemStack itemStack) {
        String name = ForgeRegistries.ITEMS.getKey((Object)itemStack.m_41720_()).toString();
        int index = CommonConfig.findIndex(name, ChatManager.getRangeItem());
        if (index == -1) {
            if (itemStack.m_41782_() && itemStack.m_41784_().m_128441_("MessageRange")) {
                itemStack.m_41784_().m_128473_("MessageRange");
                if (itemStack.m_41784_().m_128440_() == 0) {
                    itemStack.m_41751_(null);
                }
            }
            return;
        }
        String[] info = ChatManager.getRangeItem().get(index).split(",");
        if (info.length < 2) {
            return;
        }
        itemStack.m_41784_().m_128405_("MessageRange", Integer.parseInt(info[1].trim()));
    }

    public static void sendMessage(CommandSourceStack commandSourceStack, Collection<ServerPlayer> collection, PlayerChatMessage playerChatMessage, int range) {
        ChatType.Bound chattype$bound = ChatType.m_241073_((ResourceKey)ChatType.f_240674_, (CommandSourceStack)commandSourceStack);
        ServerPlayer serverPlayer = commandSourceStack.m_230896_();
        if (serverPlayer instanceof ILivingEntityAccessor) {
            ILivingEntityAccessor livingEntityAccessor = (ILivingEntityAccessor)serverPlayer;
            BlockPos pos = serverPlayer.m_20183_();
            Component component = playerChatMessage.m_245692_();
            Object message = component.getString();
            message = (String)message + " @TheMessageCutter@ " + livingEntityAccessor.getInfectionLevel() + " ; " + pos.m_123341_() + ", " + pos.m_123342_() + ", " + pos.m_123343_() + " ; " + range;
            playerChatMessage = playerChatMessage.m_241956_((Component)Component.m_237113_((String)message));
        }
        OutgoingChatMessage outgoingchatmessage = OutgoingChatMessage.m_247282_((PlayerChatMessage)playerChatMessage);
        boolean flag = false;
        for (ServerPlayer serverplayer : collection) {
            ChatType.Bound chattype$bound1 = ChatType.m_241073_((ResourceKey)ChatType.f_240668_, (CommandSourceStack)commandSourceStack).m_241018_(serverplayer.m_5446_());
            commandSourceStack.m_246719_(outgoingchatmessage, false, chattype$bound1);
            boolean flag1 = commandSourceStack.m_243061_(serverplayer);
            serverplayer.m_245069_(outgoingchatmessage, flag1, chattype$bound);
            flag |= flag1 && playerChatMessage.m_243059_();
        }
        if (flag) {
            commandSourceStack.m_243053_(PlayerList.f_243017_);
        }
    }

    @Nullable
    public static String[] parseMessage(PlayerChatMessage playerChatMessage) {
        return ChatManager.parseMessage(playerChatMessage.m_245692_().getString());
    }

    @Nullable
    public static String[] parseMessage(String info) {
        String[] infoList1 = info.split(" @TheMessageCutter@ ");
        if (infoList1.length != 2) {
            return null;
        }
        String[] infoList = infoList1[1].split(" ; ");
        if (infoList.length != 3) {
            return null;
        }
        return infoList;
    }

    public static MutableComponent lostMessage(MutableComponent component, double distance, int range) {
        if ((double)range >= distance || range < 0) {
            return component;
        }
        StringBuilder content = new StringBuilder(component.getString());
        Random random = new Random();
        double probability = Math.max((distance - (double)range) * 2.0 / (double)range, 0.1);
        for (int i = 0; i < content.length(); ++i) {
            if (!(random.nextDouble() < probability)) continue;
            content.replace(i, i + 1, "\u2026");
        }
        return Component.m_237113_((String)content.toString()).m_6270_(component.m_7383_());
    }

    static {
        RANGE_ITEM = new ArrayList<String>();
    }
}

