/*
 * Decompiled with CFR 0.152.
 */
package com.scarasol.sona.event;

import com.mojang.brigadier.CommandDispatcher;
import com.scarasol.sona.accessor.IBaseContainerBlockEntityAccessor;
import com.scarasol.sona.accessor.ICompoundContainerAccessor;
import com.scarasol.sona.accessor.ILivingEntityAccessor;
import com.scarasol.sona.command.InfectionCommand;
import com.scarasol.sona.command.InjuryCommand;
import com.scarasol.sona.command.RotCommand;
import com.scarasol.sona.command.RustCommand;
import com.scarasol.sona.configuration.CommonConfig;
import com.scarasol.sona.init.SonaSounds;
import com.scarasol.sona.manager.ChatManager;
import com.scarasol.sona.manager.DeathManager;
import com.scarasol.sona.manager.InfectionManager;
import com.scarasol.sona.manager.InjuryManager;
import com.scarasol.sona.manager.RotManager;
import com.scarasol.sona.manager.RustManager;
import com.scarasol.sona.manager.SoundManager;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ClientChatReceivedEvent;
import net.minecraftforge.event.ItemAttributeModifierEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.PlayerWakeUpEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber
public class ManagerEventHandler {
    @SubscribeEvent
    public static void onAttacked(LivingDamageEvent event) {
        Player player;
        LivingEntity target = event.getEntity();
        Entity entity = event.getSource().m_7640_();
        if (target == null || target.m_9236_().m_5776_()) {
            return;
        }
        if (target instanceof Player && ((player = (Player)target).m_7500_() || player.m_5833_())) {
            return;
        }
        if (((Boolean)CommonConfig.INFECTION_OPEN.get()).booleanValue() && entity != null) {
            InfectionManager.onAttacked(target, entity);
        }
        if (((Boolean)CommonConfig.INJURY_OPEN.get()).booleanValue()) {
            InjuryManager.onAttacked(target, event.getSource(), event.getAmount());
        }
        if (((Boolean)CommonConfig.RUST_OPEN.get()).booleanValue()) {
            RustManager.onAttacked(target);
        }
    }

    @SubscribeEvent
    public static void onUseItemFinish(LivingEntityUseItemEvent.Finish event) {
        Player player;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity == null || livingEntity.m_9236_().m_5776_()) {
            return;
        }
        if (livingEntity instanceof Player && ((player = (Player)livingEntity).m_7500_() || player.m_5833_())) {
            return;
        }
        ItemStack itemStack = event.getItem();
        if (livingEntity instanceof ILivingEntityAccessor) {
            ILivingEntityAccessor survivalEntity = (ILivingEntityAccessor)livingEntity;
            if (((Boolean)CommonConfig.INFECTION_OPEN.get()).booleanValue()) {
                InfectionManager.onUseItem(survivalEntity, itemStack);
            }
            if (((Boolean)CommonConfig.INJURY_OPEN.get()).booleanValue()) {
                InjuryManager.onUseItem(survivalEntity, itemStack);
            }
        }
        if (((Boolean)CommonConfig.ROT_OPEN.get()).booleanValue() && ((Boolean)CommonConfig.ROT_EFFECT.get()).booleanValue() && itemStack.m_41614_() && RotManager.canBeRotten(itemStack)) {
            RotManager.eatRotFood(livingEntity, itemStack);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onDeath(LivingDeathEvent event) {
        ILivingEntityAccessor survivalEntity;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity == null || livingEntity.m_9236_().m_5776_()) {
            return;
        }
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (!livingEntity.m_9236_().m_5776_()) {
                DeathManager.KeepItem(player);
            }
        }
        if (livingEntity instanceof Villager && event.getSource().m_7640_() instanceof Zombie) {
            return;
        }
        if (((Boolean)CommonConfig.INFECTION_OPEN.get()).booleanValue() && ((Boolean)CommonConfig.TURN_ZOMBIE.get()).booleanValue() && InfectionManager.canBeInfected(livingEntity) && livingEntity instanceof ILivingEntityAccessor && InfectionManager.getInfection(survivalEntity = (ILivingEntityAccessor)livingEntity) > (float)((Integer)CommonConfig.INFECTION_THRESHOLD.get()).intValue()) {
            InfectionManager.turnZombie(livingEntity);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onRespawn(PlayerEvent.PlayerRespawnEvent event) {
        Player player = event.getEntity();
        DeathManager.respawnItem(player);
    }

    @SubscribeEvent
    public static void onClone(PlayerEvent.Clone event) {
        Player player;
        if (event.isWasDeath() && (player = event.getOriginal()) instanceof ILivingEntityAccessor) {
            ILivingEntityAccessor oldPlayer = (ILivingEntityAccessor)player;
            player = event.getEntity();
            if (player instanceof ILivingEntityAccessor) {
                ILivingEntityAccessor newPlayer = (ILivingEntityAccessor)player;
                InfectionManager.init(newPlayer, oldPlayer);
                InjuryManager.init(newPlayer, oldPlayer);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerWakeUp(PlayerWakeUpEvent event) {
        Player player = event.getEntity();
        if (player == null || player.m_9236_().m_5776_()) {
            return;
        }
        if (((Boolean)CommonConfig.INJURY_OPEN.get()).booleanValue() && ((Boolean)CommonConfig.HEAL_WHILE_SLEEP.get()).booleanValue() && !event.updateLevel() && player instanceof ILivingEntityAccessor) {
            ILivingEntityAccessor survivalEntity = (ILivingEntityAccessor)player;
            InjuryManager.healBySleep(survivalEntity);
        }
    }

    @SubscribeEvent
    public static void registerCommand(RegisterCommandsEvent event) {
        InfectionCommand.registerCommand((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        InjuryCommand.registerInjuryCommand((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        InjuryCommand.registerBandageCommand((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        RotCommand.registerCommand((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        RustCommand.registerCommand((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    @SubscribeEvent
    public static void onOpen(PlayerContainerEvent.Open event) {
        if (!((Boolean)CommonConfig.ROT_OPEN.get()).booleanValue()) {
            return;
        }
        AbstractContainerMenu abstractContainerMenu = event.getContainer();
        if (abstractContainerMenu.f_38839_.isEmpty()) {
            return;
        }
        Player entity = event.getEntity();
        Container container = ((Slot)abstractContainerMenu.f_38839_.get((int)0)).f_40218_;
        if (container instanceof ICompoundContainerAccessor) {
            ICompoundContainerAccessor compoundContainer = (ICompoundContainerAccessor)container;
            container = compoundContainer.getContainer1();
        }
        RotManager.containerOpen(entity, container, abstractContainerMenu);
    }

    @SubscribeEvent
    public static void onClose(PlayerContainerEvent.Close event) {
        if (!((Boolean)CommonConfig.ROT_OPEN.get()).booleanValue()) {
            return;
        }
        AbstractContainerMenu abstractContainerMenu = event.getContainer();
        RotManager.rotTimeUpdate((List<Slot>)abstractContainerMenu.f_38839_, abstractContainerMenu.f_38839_.size() - event.getEntity().m_150109_().f_35974_.size(), event.getEntity().m_9236_().m_46467_());
    }

    @SubscribeEvent
    public static void tooltipInsert(ItemTooltipEvent itemTooltipEvent) {
        ItemStack itemStack = itemTooltipEvent.getItemStack();
        if (itemStack.m_41614_() && ((Boolean)CommonConfig.ROT_OPEN.get()).booleanValue() && RotManager.canBeRotten(itemStack)) {
            RotManager.tooltipInsert(itemTooltipEvent.getToolTip(), itemStack);
        }
        if (((Boolean)CommonConfig.RUST_OPEN.get()).booleanValue() && RustManager.canBeRust(itemStack)) {
            RustManager.tooltipInsert(itemTooltipEvent.getToolTip(), itemStack);
        }
    }

    @SubscribeEvent
    public static void rustAttributeModifierEvent(ItemAttributeModifierEvent event) {
        RustManager.addRustAttributeModifier(event);
    }

    @SubscribeEvent
    public static void useItem(PlayerInteractEvent.RightClickItem event) {
        Player player = event.getEntity();
        ItemStack mainHandItem = player.m_21205_();
        ItemStack offhandItem = player.m_21206_();
        if (!player.m_6144_() || offhandItem.m_41619_() || player.m_36335_().m_41519_(mainHandItem.m_41720_()) || player.m_36335_().m_41519_(offhandItem.m_41720_())) {
            return;
        }
        if (mainHandItem.m_41614_() && ((Boolean)CommonConfig.ROT_OPEN.get()).booleanValue() && ((Boolean)CommonConfig.ROT_WARPED.get()).booleanValue() && !RotManager.isWarped(mainHandItem) && RotManager.warpFood(player.m_21205_(), player.m_21206_(), (LivingEntity)player)) {
            player.m_36335_().m_41524_(player.m_21206_().m_41720_(), 20);
            return;
        }
        if (((Boolean)CommonConfig.RUST_OPEN.get()).booleanValue() && (RustManager.wax(mainHandItem, offhandItem, (LivingEntity)player) || RustManager.removalRust(mainHandItem, offhandItem, (LivingEntity)player))) {
            player.m_36335_().m_41524_(mainHandItem.m_41720_(), 100);
        }
    }

    @SubscribeEvent
    public static void soundDecoyTarget(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Mob) {
            Mob mob = (Mob)entity;
            if (SoundManager.isSoundOpen()) {
                SoundManager.insertAi(mob);
            }
        }
    }

    @SubscribeEvent
    public static void syncData(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            SoundManager.syncSoundWhiteList(serverPlayer);
            ChatManager.syncChatManager(serverPlayer);
        }
    }

    @SubscribeEvent
    public static void loadData(ServerStartedEvent event) {
        SoundManager.setSoundOpen((Boolean)CommonConfig.SOUND_OPEN.get());
        for (String sound : (List)CommonConfig.SOUND_WHITELIST.get()) {
            SoundManager.addSoundWhiteList(sound);
        }
        ChatManager.setChatLimit((Boolean)CommonConfig.CHAT_LIMIT.get());
        ChatManager.setChatRange((Integer)CommonConfig.CHAT_RANGE.get());
        for (String item : (List)CommonConfig.RANGE_ITEM.get()) {
            ChatManager.addRangeItem(item);
        }
    }

    @SubscribeEvent
    public static void breakLock(PlayerInteractEvent.RightClickBlock event) {
        Player player = event.getEntity();
        Level level = event.getEntity().m_9236_();
        if (level.m_5776_()) {
            return;
        }
        BlockPos blockPos = event.getHitVec().m_82425_();
        BlockEntity blockEntity = level.m_7702_(blockPos);
        BlockState blockState = level.m_8055_(blockPos);
        ItemStack itemStack = player.m_21205_();
        if (blockEntity instanceof IBaseContainerBlockEntityAccessor) {
            IBaseContainerBlockEntityAccessor baseContainerBlockEntityAccessor = (IBaseContainerBlockEntityAccessor)blockEntity;
            if (!baseContainerBlockEntityAccessor.isLocked(player)) {
                return;
            }
            int index = CommonConfig.findIndex(ForgeRegistries.ITEMS.getKey((Object)itemStack.m_41720_()).toString(), (List)CommonConfig.LOCK_BREAKER.get());
            if (index != -1 && !player.m_36335_().m_41519_(itemStack.m_41720_())) {
                String[] str = ((String)((List)CommonConfig.LOCK_BREAKER.get()).get(index)).split(",");
                if (str.length < 2) {
                    return;
                }
                if (player.m_217043_().m_188500_() * 100.0 < (double)Integer.parseInt(str[1].trim())) {
                    baseContainerBlockEntityAccessor.breakLockKey();
                } else {
                    event.setCanceled(true);
                }
                if (itemStack.m_41763_()) {
                    itemStack.m_41622_(5, (LivingEntity)player, consumer -> consumer.m_21166_(EquipmentSlot.MAINHAND));
                } else {
                    itemStack.m_41774_(1);
                }
                level.m_46796_(2001, event.getHitVec().m_82425_(), Block.m_49956_((BlockState)blockState));
                level.m_6269_(null, (Entity)event.getEntity(), (SoundEvent)SonaSounds.CRATE.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                player.m_36335_().m_41524_(itemStack.m_41720_(), ((Integer)CommonConfig.LOCK_BREAKER_COOLDOWN.get()).intValue());
            } else if (blockEntity instanceof BaseContainerBlockEntity) {
                BaseContainerBlockEntity baseContainerBlockEntity = (BaseContainerBlockEntity)blockEntity;
                event.setCanceled(true);
                player.m_5661_((Component)Component.m_237110_((String)"container.isLocked", (Object[])new Object[]{baseContainerBlockEntity.m_7755_()}), true);
                player.m_6330_(SoundEvents.f_11748_, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void blurMessage(ClientChatReceivedEvent event) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (event.getBoundChatType().f_240859_().equals(player.m_9236_().m_9598_().m_175515_(Registries.f_256873_).m_123013_(ChatType.f_237006_))) {
            return;
        }
        Component component = event.getMessage();
        String[] info = ChatManager.parseMessage(component.getString());
        if (info != null) {
            MutableComponent mutableComponent = Component.m_237113_((String)component.getString().split(" @TheMessageCutter@ ")[0]).m_6270_(component.m_7383_());
            int range = Integer.parseInt(info[2]);
            String[] posInfo = info[1].split(", ");
            if (posInfo.length == 3) {
                double distance = Math.pow(player.m_20275_(Double.parseDouble(posInfo[0]), Double.parseDouble(posInfo[1]), Double.parseDouble(posInfo[2])), 0.5);
                if (ChatManager.isChatLimit() && distance > (double)ChatManager.getChatRange() * 1.5 && !ChatManager.canReceiveBeyondMessage((Player)player) && event.isCancelable()) {
                    event.setCanceled(true);
                    return;
                }
                if (!InfectionManager.blurMessage(Float.parseFloat(info[0]), mutableComponent) && ChatManager.isChatLimit() && !Minecraft.m_91087_().f_91074_.m_20148_().equals(event.getSender())) {
                    mutableComponent = ChatManager.lostMessage(mutableComponent, distance, range);
                }
            }
            event.setMessage((Component)mutableComponent);
        }
    }
}

