/*
 * Decompiled with CFR 0.152.
 */
package com.scarasol.sona.effect;

import com.scarasol.sona.configuration.CommonConfig;
import com.scarasol.sona.effect.PhysicalEffect;
import com.scarasol.sona.init.SonaDamageTypes;
import com.scarasol.sona.init.SonaMobEffects;
import com.scarasol.sona.manager.RustManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class Corrosion
extends PhysicalEffect {
    public static final TagKey<Item> CORRODED_IMMUNE = ItemTags.create((ResourceLocation)new ResourceLocation("forge:corroded_immune"));

    public Corrosion() {
        super(MobEffectCategory.HARMFUL, -10066432);
    }

    public void m_6742_(LivingEntity entity, int amplifier) {
        float damage = (float)(this.equipmentCorroded(entity, amplifier) * (double)(amplifier + 1) / (0.2 * (double)(amplifier + 1) + 1.0));
        if (damage > 0.0f && ((Boolean)CommonConfig.OVER_DOT.get()).booleanValue()) {
            entity.f_19802_ = 0;
        }
        entity.m_6469_(SonaDamageTypes.damageSource(entity.m_9236_().m_9598_(), SonaDamageTypes.CORROSION), damage);
        if (entity.m_21023_((MobEffect)SonaMobEffects.SLIMINESS.get())) {
            int level = entity.m_21124_((MobEffect)SonaMobEffects.SLIMINESS.get()).m_19564_() + 1;
            entity.m_21195_((MobEffect)SonaMobEffects.SLIMINESS.get());
            entity.m_21195_((MobEffect)SonaMobEffects.CORROSION.get());
            entity.m_9236_().m_254849_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), (float)((amplifier + 1 + level) / 2), Level.ExplosionInteraction.NONE);
        }
    }

    public double equipmentCorroded(LivingEntity entity, int amplifier) {
        double exposed = 0.0;
        for (int i = 0; i < 4; ++i) {
            EquipmentSlot equipmentSlot = EquipmentSlot.m_20744_((EquipmentSlot.Type)EquipmentSlot.Type.ARMOR, (int)i);
            ItemStack armor = entity.m_6844_(equipmentSlot);
            if (armor.m_41619_()) {
                exposed += 0.25;
                continue;
            }
            if (!armor.m_204117_(CORRODED_IMMUNE)) {
                armor.m_41622_((int)Math.pow(amplifier + 1, 2.0), entity, consumer -> consumer.m_21166_(equipmentSlot));
            }
            if (!((Boolean)CommonConfig.RUST_OPEN.get()).booleanValue() || !RustManager.canBeRust(armor)) continue;
            RustManager.addRust(armor, -(amplifier + 1));
        }
        return exposed;
    }

    @Override
    public boolean m_6584_(int duration, int amplifier) {
        return duration % 20 == 0;
    }
}

