/*
 * Decompiled with CFR 0.152.
 */
package com.scarasol.sona.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.scarasol.sona.configuration.CommonConfig;
import com.scarasol.sona.manager.RotManager;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class RotCommand {
    public static void registerCommand(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"rot").requires(s -> s.m_6761_(2))).then(Commands.m_82127_((String)"get").executes(arguments -> {
            RotCommand.commandProcess((CommandContext<CommandSourceStack>)arguments, 0);
            return 0;
        }))).then(Commands.m_82127_((String)"set").then(Commands.m_82129_((String)"number", (ArgumentType)DoubleArgumentType.doubleArg((double)0.0, (double)100.0)).executes(arguments -> {
            RotCommand.commandProcess((CommandContext<CommandSourceStack>)arguments, 1);
            return 0;
        })))).then(Commands.m_82127_((String)"add").then(Commands.m_82129_((String)"number", (ArgumentType)DoubleArgumentType.doubleArg((double)-100.0, (double)100.0)).executes(arguments -> {
            RotCommand.commandProcess((CommandContext<CommandSourceStack>)arguments, 2);
            return 0;
        }))));
    }

    private static void commandProcess(CommandContext<CommandSourceStack> arguments, int process) {
        Entity entity = ((CommandSourceStack)arguments.getSource()).m_81373_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (((Boolean)CommonConfig.ROT_OPEN.get()).booleanValue()) {
                if (player.m_21205_().m_41614_() && RotManager.canBeRotten(player.m_21205_())) {
                    if (process == 0) {
                        RotCommand.getCommand(player, player.m_21205_());
                    } else {
                        double rotLevel = DoubleArgumentType.getDouble(arguments, (String)"number");
                        if (process == 1) {
                            RotCommand.setCommand(player, player.m_21205_(), rotLevel);
                        } else {
                            RotCommand.addCommand(player, player.m_21205_(), rotLevel);
                        }
                    }
                } else {
                    player.m_5661_((Component)Component.m_237113_((String)Component.m_237115_((String)"command.sona.not_rot").getString()), false);
                }
            } else {
                player.m_5661_((Component)Component.m_237113_((String)Component.m_237115_((String)"command.sona.rot.close").getString()), false);
            }
        }
    }

    private static void addCommand(Player player, ItemStack itemStack, double rotLevel) {
        RotManager.addActualRot(itemStack, rotLevel);
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            RotManager.syncRotValue(RotManager.getRot(itemStack), player.m_150109_().f_35977_, true, serverPlayer);
        }
        player.m_5661_((Component)Component.m_237113_((String)Component.m_237110_((String)"command.sona.modify_rot.success", (Object[])new Object[]{itemStack.m_41611_(), RotManager.getRot(itemStack)}).getString()), false);
    }

    private static void setCommand(Player player, ItemStack itemStack, double rotLevel) {
        RotManager.putRot(itemStack, rotLevel);
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            RotManager.syncRotValue(RotManager.getRot(itemStack), player.m_150109_().f_35977_, true, serverPlayer);
        }
        player.m_5661_((Component)Component.m_237113_((String)Component.m_237110_((String)"command.sona.modify_rot.success", (Object[])new Object[]{itemStack.m_41611_(), rotLevel}).getString()), false);
    }

    private static void getCommand(Player player, ItemStack itemStack) {
        String rotLevel = String.format("%.2f", RotManager.getRot(itemStack));
        player.m_5661_((Component)Component.m_237113_((String)Component.m_237110_((String)"command.sona.get_rot.success", (Object[])new Object[]{itemStack.m_41611_(), rotLevel}).getString()), false);
    }
}

