/*
 * Decompiled with CFR 0.152.
 */
package com.scarasol.sona.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.scarasol.sona.accessor.ILivingEntityAccessor;
import com.scarasol.sona.configuration.CommonConfig;
import com.scarasol.sona.manager.InjuryManager;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.util.FakePlayerFactory;

public class InjuryCommand {
    public static void registerInjuryCommand(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"injury").requires(s -> s.m_6761_(2))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.m_82129_((String)"entity", (ArgumentType)EntityArgument.m_91466_()).then(Commands.m_82127_((String)"get").executes(arguments -> {
            InjuryCommand.commandProcess((CommandContext<CommandSourceStack>)arguments, true, 0);
            return 0;
        }))).then(Commands.m_82127_((String)"set").then(Commands.m_82129_((String)"number", (ArgumentType)DoubleArgumentType.doubleArg((double)0.0, (double)100.0)).executes(arguments -> {
            InjuryCommand.commandProcess((CommandContext<CommandSourceStack>)arguments, true, 1);
            return 0;
        })))).then(Commands.m_82127_((String)"add").then(Commands.m_82129_((String)"number", (ArgumentType)DoubleArgumentType.doubleArg((double)-100.0, (double)100.0)).executes(arguments -> {
            InjuryCommand.commandProcess((CommandContext<CommandSourceStack>)arguments, true, 2);
            return 0;
        })))));
    }

    public static void registerBandageCommand(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"bandage").requires(s -> s.m_6761_(2))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.m_82129_((String)"entity", (ArgumentType)EntityArgument.m_91466_()).then(Commands.m_82127_((String)"get").executes(arguments -> {
            InjuryCommand.commandProcess((CommandContext<CommandSourceStack>)arguments, false, 0);
            return 0;
        }))).then(Commands.m_82127_((String)"set").then(Commands.m_82129_((String)"number", (ArgumentType)DoubleArgumentType.doubleArg((double)0.0, (double)50.0)).executes(arguments -> {
            InjuryCommand.commandProcess((CommandContext<CommandSourceStack>)arguments, false, 1);
            return 0;
        })))).then(Commands.m_82127_((String)"add").then(Commands.m_82129_((String)"number", (ArgumentType)DoubleArgumentType.doubleArg((double)-50.0, (double)50.0)).executes(arguments -> {
            InjuryCommand.commandProcess((CommandContext<CommandSourceStack>)arguments, false, 2);
            return 0;
        })))));
    }

    private static void commandProcess(CommandContext<CommandSourceStack> arguments, boolean injury, int process) {
        Entity entity = ((CommandSourceStack)arguments.getSource()).m_81373_();
        if (entity == null) {
            entity = FakePlayerFactory.getMinecraft((ServerLevel)((CommandSourceStack)arguments.getSource()).m_81372_());
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            try {
                Entity target = EntityArgument.m_91452_(arguments, (String)"entity");
                if (((Boolean)CommonConfig.INJURY_OPEN.get()).booleanValue()) {
                    if (process == 0) {
                        InjuryCommand.getInjuryCommand(player, target, injury);
                    } else {
                        float level = (float)DoubleArgumentType.getDouble(arguments, (String)"number");
                        if (process == 1) {
                            InjuryCommand.setInjuryCommand(player, target, level, injury);
                        } else {
                            InjuryCommand.addInjuryCommand(player, target, level, injury);
                        }
                    }
                } else {
                    player.m_5661_((Component)Component.m_237113_((String)Component.m_237115_((String)"command.sona.injury.close").getString()), false);
                }
            }
            catch (CommandSyntaxException e) {
                player.m_5661_((Component)Component.m_237113_((String)Component.m_237115_((String)"command.sona.not_found").getString()), false);
            }
        }
    }

    private static void getInjuryCommand(Player player, Entity target, boolean injury) {
        if (target instanceof ILivingEntityAccessor) {
            ILivingEntityAccessor survivalEntity = (ILivingEntityAccessor)target;
            if (injury) {
                String injuryLevel = String.format("%.2f", Float.valueOf(InjuryManager.getInjury(survivalEntity)));
                player.m_5661_((Component)Component.m_237113_((String)Component.m_237110_((String)"command.sona.get_injury.success", (Object[])new Object[]{target.m_5446_(), injuryLevel}).getString()), false);
            } else {
                String bandageLevel = String.format("%.2f", Float.valueOf(InjuryManager.getBandage(survivalEntity)));
                player.m_5661_((Component)Component.m_237113_((String)Component.m_237110_((String)"command.sona.get_bandage.success", (Object[])new Object[]{target.m_5446_(), bandageLevel}).getString()), false);
            }
        }
    }

    private static void setInjuryCommand(Player player, Entity target, float level, boolean injury) {
        if (target instanceof ILivingEntityAccessor) {
            ILivingEntityAccessor survivalEntity = (ILivingEntityAccessor)target;
            if (injury) {
                InjuryManager.setInjury(survivalEntity, level);
                player.m_5661_((Component)Component.m_237113_((String)Component.m_237110_((String)"command.sona.modify_injury.success", (Object[])new Object[]{target.m_5446_(), Float.valueOf(InjuryManager.getInjury(survivalEntity))}).getString()), false);
            } else {
                InjuryManager.setBandageSafe(survivalEntity, level);
                player.m_5661_((Component)Component.m_237113_((String)Component.m_237110_((String)"command.sona.modify_bandage.success", (Object[])new Object[]{target.m_5446_(), Float.valueOf(InjuryManager.getBandage(survivalEntity))}).getString()), false);
            }
        }
    }

    private static void addInjuryCommand(Player player, Entity target, float level, boolean injury) {
        if (target instanceof ILivingEntityAccessor) {
            ILivingEntityAccessor survivalEntity = (ILivingEntityAccessor)target;
            if (injury) {
                InjuryManager.addActualInjury(survivalEntity, level);
                player.m_5661_((Component)Component.m_237113_((String)Component.m_237110_((String)"command.sona.modify_injury.success", (Object[])new Object[]{target.m_5446_(), Float.valueOf(InjuryManager.getInjury(survivalEntity))}).getString()), false);
            } else {
                InjuryManager.addActualBandage(survivalEntity, level);
                player.m_5661_((Component)Component.m_237113_((String)Component.m_237110_((String)"command.sona.modify_bandage.success", (Object[])new Object[]{target.m_5446_(), Float.valueOf(InjuryManager.getBandage(survivalEntity))}).getString()), false);
            }
        }
    }
}

