/*
 * Decompiled with CFR 0.152.
 */
package com.scarasol.sona.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.scarasol.sona.accessor.ILivingEntityAccessor;
import com.scarasol.sona.configuration.CommonConfig;
import com.scarasol.sona.manager.InfectionManager;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.registries.ForgeRegistries;

public class InfectionCommand {
    public static void registerCommand(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"infection").requires(s -> s.m_6761_(2))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.m_82129_((String)"entity", (ArgumentType)EntityArgument.m_91449_()).then(Commands.m_82127_((String)"get").executes(arguments -> {
            InfectionCommand.commandProcess((CommandContext<CommandSourceStack>)arguments, 0);
            return 0;
        }))).then(Commands.m_82127_((String)"set").then(Commands.m_82129_((String)"number", (ArgumentType)DoubleArgumentType.doubleArg((double)0.0, (double)100.0)).executes(arguments -> {
            InfectionCommand.commandProcess((CommandContext<CommandSourceStack>)arguments, 1);
            return 0;
        })))).then(Commands.m_82127_((String)"add").then(Commands.m_82129_((String)"number", (ArgumentType)DoubleArgumentType.doubleArg((double)-100.0, (double)100.0)).executes(arguments -> {
            InfectionCommand.commandProcess((CommandContext<CommandSourceStack>)arguments, 2);
            return 0;
        })))));
    }

    private static void commandProcess(CommandContext<CommandSourceStack> arguments, int process) {
        Entity entity = ((CommandSourceStack)arguments.getSource()).m_81373_();
        if (entity == null) {
            entity = FakePlayerFactory.getMinecraft((ServerLevel)((CommandSourceStack)arguments.getSource()).m_81372_());
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            try {
                Entity target = EntityArgument.m_91452_(arguments, (String)"entity");
                if (((Boolean)CommonConfig.INFECTION_OPEN.get()).booleanValue()) {
                    if (target instanceof Player || ((List)CommonConfig.SUSCEPTIBLE_POPULATION.get()).contains(ForgeRegistries.ENTITY_TYPES.getKey((Object)target.m_6095_()).toString())) {
                        if (process == 0) {
                            InfectionCommand.getCommand(player, target);
                        } else {
                            float infectionLevel = (float)DoubleArgumentType.getDouble(arguments, (String)"number");
                            if (process == 1) {
                                InfectionCommand.setCommand(player, target, infectionLevel);
                            } else {
                                InfectionCommand.addCommand(player, target, infectionLevel);
                            }
                        }
                    } else {
                        player.m_5661_((Component)Component.m_237113_((String)Component.m_237115_((String)"command.sona.infection.uninfected").getString()), false);
                    }
                } else {
                    player.m_5661_((Component)Component.m_237113_((String)Component.m_237115_((String)"command.sona.infection.close").getString()), false);
                }
            }
            catch (CommandSyntaxException e) {
                player.m_5661_((Component)Component.m_237113_((String)Component.m_237115_((String)"command.sona.not_found").getString()), false);
            }
        }
    }

    private static void getCommand(Player player, Entity target) {
        if (target instanceof ILivingEntityAccessor) {
            ILivingEntityAccessor survivalEntity = (ILivingEntityAccessor)target;
            String infectionLevel = String.format("%.2f", Float.valueOf(InfectionManager.getInfection(survivalEntity)));
            player.m_5661_((Component)Component.m_237113_((String)Component.m_237110_((String)"command.sona.get_infection.success", (Object[])new Object[]{target.m_5446_(), infectionLevel}).getString()), false);
        }
    }

    private static void setCommand(Player player, Entity target, float infectionLevel) {
        if (target instanceof ILivingEntityAccessor) {
            ILivingEntityAccessor survivalEntity = (ILivingEntityAccessor)target;
            InfectionManager.setInfection(survivalEntity, infectionLevel);
            player.m_5661_((Component)Component.m_237113_((String)Component.m_237110_((String)"command.sona.modify_infection.success", (Object[])new Object[]{target.m_5446_(), Float.valueOf(infectionLevel)}).getString()), false);
        }
    }

    private static void addCommand(Player player, Entity target, float infectionLevel) {
        if (target instanceof ILivingEntityAccessor) {
            ILivingEntityAccessor survivalEntity = (ILivingEntityAccessor)target;
            InfectionManager.addActualInfection(survivalEntity, infectionLevel);
            player.m_5661_((Component)Component.m_237113_((String)Component.m_237110_((String)"command.sona.modify_infection.success", (Object[])new Object[]{target.m_5446_(), Float.valueOf(InfectionManager.getInfection(survivalEntity))}).getString()), false);
        }
    }
}

