/*
 * Decompiled with CFR 0.152.
 */
package com.scarasol.sona.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.scarasol.sona.configuration.CommonConfig;
import com.scarasol.sona.manager.RotManager;
import com.scarasol.sona.manager.RustManager;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
@OnlyIn(value=Dist.CLIENT)
public class ItemMarkHandler {
    private static final ResourceLocation SAFE = new ResourceLocation("sona:textures/screens/safe.png");
    private static final ResourceLocation MILD = new ResourceLocation("sona:textures/screens/mild.png");
    private static final ResourceLocation BAD = new ResourceLocation("sona:textures/screens/bad.png");
    private static final ResourceLocation AWFUL = new ResourceLocation("sona:textures/screens/awful.png");
    private static final ResourceLocation WAXED = new ResourceLocation("sona:textures/screens/waxed.png");
    private static final ResourceLocation WARPED = new ResourceLocation("sona:textures/screens/warped.png");

    public static void renderMark(GuiGraphics guiGraphics, Slot slot) {
        if (!slot.m_6657_()) {
            return;
        }
        if (((Boolean)CommonConfig.ROT_OPEN.get()).booleanValue() && RotManager.canBeRotten(slot.m_7993_()) && slot.m_7993_().m_41614_()) {
            ItemMarkHandler.renderRot(guiGraphics, slot.m_7993_(), slot.f_40220_, slot.f_40221_);
        } else if (((Boolean)CommonConfig.RUST_OPEN.get()).booleanValue() && RustManager.canBeRust(slot.m_7993_())) {
            ItemMarkHandler.renderRust(guiGraphics, slot.m_7993_(), slot.f_40220_, slot.f_40221_);
        }
    }

    public static void renderMark(GuiGraphics guiGraphics, ItemStack itemStack, int x, int y) {
        if (itemStack.m_41619_()) {
            return;
        }
        if (((Boolean)CommonConfig.ROT_OPEN.get()).booleanValue() && RotManager.canBeRotten(itemStack) && itemStack.m_41614_()) {
            ItemMarkHandler.renderRot(guiGraphics, itemStack, x, y);
        } else if (((Boolean)CommonConfig.RUST_OPEN.get()).booleanValue() && RustManager.canBeRust(itemStack)) {
            ItemMarkHandler.renderRust(guiGraphics, itemStack, x, y);
        }
    }

    private static void renderRot(GuiGraphics guiGraphics, ItemStack itemStack, int x, int y) {
        RenderSystem.disableDepthTest();
        double value = RotManager.getRot(itemStack);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (RotManager.isWarped(itemStack)) {
            guiGraphics.m_280163_(WARPED, x, y, 0.0f, 0.0f, 16, 16, 16, 16);
        }
        guiGraphics.m_280163_(ItemMarkHandler.rotLevel(value), x, y, 0.0f, 0.0f, 8, 8, 8, 8);
    }

    private static void renderRust(GuiGraphics guiGraphics, ItemStack itemStack, int x, int y) {
        RenderSystem.disableDepthTest();
        double value = RustManager.getRust(itemStack);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.m_280163_(ItemMarkHandler.rustLevel(value), x, y, 0.0f, 0.0f, 8, 8, 8, 8);
        if (RustManager.isWaxed(itemStack)) {
            guiGraphics.m_280163_(WAXED, x, y + 8, 0.0f, 0.0f, 8, 8, 8, 8);
        }
    }

    private static ResourceLocation rustLevel(double value) {
        if (value >= 70.0) {
            return AWFUL;
        }
        if (value >= 40.0) {
            return BAD;
        }
        return SAFE;
    }

    private static ResourceLocation rotLevel(double value) {
        if (value >= 90.0) {
            return AWFUL;
        }
        if (value >= 70.0) {
            return BAD;
        }
        if (value >= 40.0) {
            return MILD;
        }
        return SAFE;
    }
}

